/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.connection;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public final class Workaround {
    private Workaround() {
    }

    public static URL fixJarURL(URL url) {
        String newURLStr;
        Permission urlConnectionPermission;
        URLConnection urlConnection;
        String originalURLProtocol = url.getProtocol();
        if (!"jar".equalsIgnoreCase(originalURLProtocol)) {
            return url;
        }
        String originalURLString = url.toString();
        int bangSlashIndex = originalURLString.indexOf("!/");
        if (bangSlashIndex > -1) {
            return url;
        }
        String originalURLPath = url.getPath();
        try {
            urlConnection = url.openConnection();
            if (urlConnection == null) {
                throw new IOException("urlConnection is null");
            }
        }
        catch (IOException e) {
            return url;
        }
        try {
            urlConnectionPermission = urlConnection.getPermission();
            if (urlConnectionPermission == null) {
                throw new IOException("urlConnectionPermission is null");
            }
        }
        catch (IOException e) {
            return url;
        }
        String urlConnectionPermissionName = urlConnectionPermission.getName();
        if (urlConnectionPermissionName == null) {
            return url;
        }
        File file = new File(urlConnectionPermissionName);
        if (!file.exists()) {
            return url;
        }
        try {
            newURLStr = "jar:" + file.toURI().toURL().toExternalForm() + "!/" + originalURLPath;
        }
        catch (MalformedURLException e) {
            return url;
        }
        try {
            url = new URL(newURLStr);
        }
        catch (MalformedURLException e) {
            return url;
        }
        return url;
    }
}

