/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.connection;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.psammead.mwapi.config.ConfigDeserializer;
import net.psammead.mwapi.config.ConfigInfo;
import net.psammead.mwapi.config.ConfigSyntaxException;
import net.psammead.mwapi.config.Family;
import net.psammead.mwapi.config.Site;
import net.psammead.mwapi.connection.ConfigException;
import net.psammead.mwapi.connection.TitleUtil;
import net.psammead.mwapi.connection.Workaround;
import net.psammead.mwapi.ui.UnsupportedWikiException;
import net.psammead.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigManager {
    public final List<String> wikiList;
    private Map<String, Family> familyCache = new HashMap<String, Family>();
    private Map<String, Site> siteCache = new HashMap<String, Site>();
    private List<String> supportedWikiNames = new ArrayList<String>();

    public ConfigManager() throws ConfigException {
        try {
            URL configuration = this.configBuiltin(ConfigInfo.familyListFileName());
            String code = IOUtil.readStringFromURL((URL)configuration, (String)"UTF-8");
            this.wikiList = ConfigDeserializer.deserializeFamilyList(code);
        }
        catch (Exception e) {
            throw new ConfigException("cannot load families list", e);
        }
        for (String familyName : this.wikiList) {
            try {
                URL familyDescriptor = this.configBuiltin(ConfigInfo.familyFileName(familyName));
                this.loadFamily(familyDescriptor);
            }
            catch (Exception e) {
                throw new ConfigException("cannot load family description: " + familyName, e);
            }
        }
    }

    public List<String> getSupportedWikiNames() {
        return Collections.unmodifiableList(this.supportedWikiNames);
    }

    public Family getFamily(String familyName) {
        return this.familyCache.get(familyName.toLowerCase());
    }

    public Site getSite(String wiki) throws UnsupportedWikiException {
        String[] parts = wiki.split(":");
        String familyName = parts[0];
        String siteLanguage = parts.length > 1 ? parts[1] : null;
        Family family = this.getFamily(familyName);
        if (family == null) {
            throw new UnsupportedWikiException("the family: " + familyName + " is not supported");
        }
        Site site = this.getSite(family, siteLanguage);
        if (site == null) {
            throw new UnsupportedWikiException("the language: " + siteLanguage + " is not supported by family: " + familyName);
        }
        return site;
    }

    public Site getSite(Family family, String siteLanguage) throws UnsupportedWikiException {
        String wiki;
        Site site;
        if (siteLanguage != null) {
            siteLanguage = siteLanguage.toLowerCase();
            if (!family.multilingual) {
                return null;
            }
            if (!family.supportedLanguages.contains(siteLanguage)) {
                return null;
            }
        }
        if ((site = this.siteCache.get(wiki = TitleUtil.buildWiki(family.name, siteLanguage))) == null) {
            throw new UnsupportedWikiException("the wiki: " + wiki + "is not supported");
        }
        return site;
    }

    public Family loadFamily(URL familyDescriptor) throws ConfigException {
        try {
            String code = IOUtil.readStringFromURL((URL)familyDescriptor, (String)"UTF-8");
            Family family = ConfigDeserializer.deserializeFamily(code);
            String familyName = family.name;
            if (family.multilingual) {
                for (String siteName : family.supportedLanguages) {
                    String siteFileName = ConfigInfo.siteFileName(familyName, siteName);
                    URL siteDescriptor = new URL(Workaround.fixJarURL(familyDescriptor), siteFileName);
                    this.addSite(this.loadSite(siteDescriptor));
                }
            } else {
                String siteFileName = ConfigInfo.siteFileName(familyName, null);
                URL siteDescriptor = new URL(Workaround.fixJarURL(familyDescriptor), siteFileName);
                this.addSite(this.loadSite(siteDescriptor));
            }
            Family old = this.getFamily(familyName);
            if (old != null) {
                this.removeFamily(old);
            }
            this.addFamily(family);
            return family;
        }
        catch (ConfigSyntaxException e) {
            throw new ConfigException("cannot load family description: " + familyDescriptor, e);
        }
        catch (IOException e) {
            throw new ConfigException("cannot load family description: " + familyDescriptor, e);
        }
    }

    private void addFamily(Family family) {
        String familyNameLC = family.name.toLowerCase();
        if (this.familyCache.containsKey(familyNameLC)) {
            return;
        }
        this.familyCache.put(familyNameLC, family);
        if (family.shortcut != null) {
            this.familyCache.put(family.shortcut.toLowerCase(), family);
        }
        if (family.multilingual) {
            for (String siteName : family.supportedLanguages) {
                this.supportedWikiNames.add(family.name + ":" + siteName);
            }
        } else {
            this.supportedWikiNames.add(family.name);
        }
        Collections.sort(this.supportedWikiNames);
    }

    private Site loadSite(URL siteDescriptor) throws ConfigException {
        try {
            String code = IOUtil.readStringFromURL((URL)siteDescriptor, (String)"UTF-8");
            return ConfigDeserializer.deserializeSite(code);
        }
        catch (IOException e) {
            throw new ConfigException("cannot load site description: " + siteDescriptor, e);
        }
        catch (ConfigSyntaxException e) {
            throw new ConfigException("cannot load site description: " + siteDescriptor, e);
        }
    }

    private void addSite(Site site) {
        this.siteCache.put(site.wiki, site);
    }

    private void removeFamily(Family family) {
        this.familyCache.remove(family.name.toLowerCase());
        if (family.shortcut != null) {
            this.familyCache.remove(family.shortcut.toLowerCase());
        }
        if (family.multilingual) {
            Iterator<String> it = this.supportedWikiNames.iterator();
            while (it.hasNext()) {
                String wikiName = it.next();
                if (!wikiName.startsWith(family.name + ":")) continue;
                it.remove();
            }
        } else {
            this.supportedWikiNames.remove(family.name);
        }
    }

    private URL configBuiltin(String name) throws FileNotFoundException {
        String path = "net/psammead/mwapi/config/" + name;
        URL url = this.getClass().getClassLoader().getResource(path);
        if (url == null) {
            throw new FileNotFoundException("resource " + path + " could not be found");
        }
        return url;
    }
}

