/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ref;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class UncheckedWeakIdentityHashMap
implements Map {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue queue = new ReferenceQueue();
    private volatile int modCount;
    volatile transient Set keySet = null;
    volatile transient Collection values = null;
    private static final Object NULL_KEY = new Object();
    private transient Set entrySet = null;

    public UncheckedWeakIdentityHashMap(int initialCapacity, float loadFactor) {
        int capacity;
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (initialCapacity > 0x40000000) {
            initialCapacity = 0x40000000;
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        for (capacity = 1; capacity < initialCapacity; capacity <<= 1) {
        }
        this.table = new Entry[capacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
    }

    public UncheckedWeakIdentityHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public UncheckedWeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = new Entry[16];
    }

    public UncheckedWeakIdentityHashMap(Map t) {
        this(Math.max((int)((float)t.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(t);
    }

    private static Object maskNull(Object key) {
        return key == null ? NULL_KEY : key;
    }

    private static Object unmaskNull(Object key) {
        return key == NULL_KEY ? null : key;
    }

    int hash(Object x) {
        int h = System.identityHashCode(x);
        return h - (h << 7);
    }

    static int indexFor(int h, int length) {
        return h & length - 1;
    }

    private void expungeStaleEntries() {
        Reference r;
        block0: while ((r = this.queue.poll()) != null) {
            Entry prev;
            Entry e = (Entry)r;
            int h = e.hash;
            int i = UncheckedWeakIdentityHashMap.indexFor(h, this.table.length);
            Entry p = prev = this.table[i];
            while (p != null) {
                Entry next = p.next;
                if (p == e) {
                    if (prev == e) {
                        this.table[i] = next;
                    } else {
                        prev.next = next;
                    }
                    e.next = null;
                    e.value = null;
                    --this.size;
                    continue block0;
                }
                prev = p;
                p = next;
            }
        }
    }

    private Entry[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Object get(Object key) {
        Object k = UncheckedWeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = UncheckedWeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == h && k == e.get()) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    Entry getEntry(Object key) {
        Object k = UncheckedWeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int index = UncheckedWeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[index];
        while (e != null && (e.hash != h || k != e.get())) {
            e = e.next;
        }
        return e;
    }

    public Object put(Object key, Object value) {
        Object k = UncheckedWeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int i = UncheckedWeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = tab[i];
        while (e != null) {
            if (h == e.hash && k == e.get()) {
                Object oldValue = e.value;
                if (value != oldValue) {
                    e.value = value;
                }
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        tab[i] = new Entry(k, value, this.queue, h, tab[i]);
        if (++this.size >= this.threshold) {
            this.resize(tab.length * 2);
        }
        return null;
    }

    void resize(int newCapacity) {
        Entry[] oldTable = this.getTable();
        int oldCapacity = oldTable.length;
        if (this.size < this.threshold || oldCapacity > newCapacity) {
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        this.transfer(oldTable, newTable);
        this.table = newTable;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(newTable, oldTable);
            this.table = oldTable;
        }
    }

    private void transfer(Entry[] src, Entry[] dest) {
        for (int j = 0; j < src.length; ++j) {
            Entry e = src[j];
            src[j] = null;
            while (e != null) {
                Entry next = e.next;
                Object key = e.get();
                if (key == null) {
                    e.next = null;
                    e.value = null;
                    --this.size;
                } else {
                    int i = UncheckedWeakIdentityHashMap.indexFor(e.hash, dest.length);
                    e.next = dest[i];
                    dest[i] = e;
                }
                e = next;
            }
        }
    }

    public void putAll(Map t) {
        int n = t.size();
        if (n == 0) {
            return;
        }
        if (n >= this.threshold) {
            int capacity;
            if ((n = (int)((float)n / this.loadFactor + 1.0f)) > 0x40000000) {
                n = 0x40000000;
            }
            for (capacity = this.table.length; capacity < n; capacity <<= 1) {
            }
            this.resize(capacity);
        }
        for (Map.Entry e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Object remove(Object key) {
        Entry prev;
        Object k = UncheckedWeakIdentityHashMap.maskNull(key);
        int h = this.hash(k);
        Entry[] tab = this.getTable();
        int i = UncheckedWeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && k == e.get()) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e.value;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    Entry removeMapping(Object o) {
        Entry prev;
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Entry[] tab = this.getTable();
        Map.Entry entry = (Map.Entry)o;
        Object k = UncheckedWeakIdentityHashMap.maskNull(entry.getKey());
        int h = this.hash(k);
        int i = UncheckedWeakIdentityHashMap.indexFor(h, tab.length);
        Entry e = prev = tab[i];
        while (e != null) {
            Entry next = e.next;
            if (h == e.hash && e.equals(entry)) {
                ++this.modCount;
                --this.size;
                if (prev == e) {
                    tab[i] = next;
                } else {
                    prev.next = next;
                }
                return e;
            }
            prev = e;
            e = next;
        }
        return null;
    }

    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    public boolean containsValue(Object value) {
        if (value == null) {
            return this.containsNullValue();
        }
        Entry[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] tab = this.getTable();
        int i = tab.length;
        while (i-- > 0) {
            Entry e = tab[i];
            while (e != null) {
                if (e.value == null) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    static class SimpleEntry
    implements Map.Entry {
        Object key;
        Object value;

        public SimpleEntry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public SimpleEntry(Map.Entry e) {
            this.key = e.getKey();
            this.value = e.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SimpleEntry.eq(this.key, e.getKey()) && SimpleEntry.eq(this.value, e.getValue());
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Entry candidate = UncheckedWeakIdentityHashMap.this.getEntry(k);
            return candidate != null && candidate.equals(e);
        }

        public boolean remove(Object o) {
            return UncheckedWeakIdentityHashMap.this.removeMapping(o) != null;
        }

        public int size() {
            return UncheckedWeakIdentityHashMap.this.size();
        }

        public void clear() {
            UncheckedWeakIdentityHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList<SimpleEntry> c = new ArrayList<SimpleEntry>(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(new SimpleEntry((Map.Entry)i.next()));
            }
            return c.toArray(a);
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return UncheckedWeakIdentityHashMap.this.size();
        }

        public boolean contains(Object o) {
            return UncheckedWeakIdentityHashMap.this.containsValue(o);
        }

        public void clear() {
            UncheckedWeakIdentityHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return UncheckedWeakIdentityHashMap.this.size();
        }

        public boolean contains(Object o) {
            return UncheckedWeakIdentityHashMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            if (UncheckedWeakIdentityHashMap.this.containsKey(o)) {
                UncheckedWeakIdentityHashMap.this.remove(o);
                return true;
            }
            return false;
        }

        public void clear() {
            UncheckedWeakIdentityHashMap.this.clear();
        }

        public Object[] toArray() {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray();
        }

        public Object[] toArray(Object[] a) {
            ArrayList c = new ArrayList(this.size());
            Iterator i = this.iterator();
            while (i.hasNext()) {
                c.add(i.next());
            }
            return c.toArray(a);
        }
    }

    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        public Object next() {
            return this.nextEntry();
        }
    }

    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        public Object next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }
    }

    private abstract class HashIterator
    implements Iterator {
        int index;
        Entry entry = null;
        Entry lastReturned = null;
        int expectedModCount = UncheckedWeakIdentityHashMap.access$400(UncheckedWeakIdentityHashMap.this);
        Object nextKey = null;
        Object currentKey = null;

        HashIterator() {
            this.index = UncheckedWeakIdentityHashMap.this.size() != 0 ? UncheckedWeakIdentityHashMap.this.table.length : 0;
        }

        public boolean hasNext() {
            Entry[] t = UncheckedWeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry e = this.entry;
                int i = this.index;
                while (e == null && i > 0) {
                    e = t[--i];
                }
                this.entry = e;
                this.index = i;
                if (e == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = e.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry nextEntry() {
            if (UncheckedWeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (UncheckedWeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            UncheckedWeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = UncheckedWeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    private static class Entry
    extends WeakReference
    implements Map.Entry {
        private Object value;
        private final int hash;
        private Entry next;

        Entry(Object key, Object value, ReferenceQueue queue, int hash, Entry next) {
            super(key, queue);
            this.value = value;
            this.hash = hash;
            this.next = next;
        }

        public Object getKey() {
            return UncheckedWeakIdentityHashMap.unmaskNull(this.get());
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object newValue) {
            Object oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return k1 == (k2 = e.getKey()) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        public int hashCode() {
            Object k = this.getKey();
            Object v = this.getValue();
            return (k == null ? 0 : System.identityHashCode(k)) ^ (v == null ? 0 : v.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

