/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringUtil {
    private StringUtil() {
    }

    public static String safeToString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String escapeRegexp(String in) {
        int len = in.length();
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    out.append('\\');
                    break;
                }
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String cutAtStart(String text, String prefix) {
        if (!text.startsWith(prefix)) {
            return null;
        }
        return text.substring(prefix.length());
    }

    public static String cutAtEnd(String text, String suffix) {
        if (!text.endsWith(suffix)) {
            return null;
        }
        return text.substring(0, text.length() - suffix.length());
    }

    public static String[] split(String text, char separator) {
        int pos = 0;
        int len = text.length();
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c != separator) continue;
            out.add(text.substring(pos, i));
            pos = i + 1;
        }
        if (pos < len) {
            out.add(text.substring(pos, len));
        }
        return out.toArray(new String[out.size()]);
    }

    public static String[] split(String s, String separator) {
        ArrayList<String> out = new ArrayList<String>();
        int pos = 0;
        while ((pos = s.indexOf(separator, pos)) != -1) {
            out.add(s.substring(0, pos));
            s = s.substring(pos + separator.length());
        }
        out.add(s);
        return out.toArray(new String[out.size()]);
    }

    public static String[] splitFirst(String s, String separator) {
        String[] stringArray;
        int pos = s.indexOf(separator);
        if (pos != -1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, pos);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(pos + separator.length());
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = s;
        }
        return stringArray;
    }

    public static String[] splitLast(String s, String separator) {
        String[] stringArray;
        int pos = s.lastIndexOf(separator);
        if (pos != -1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, pos);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(pos + separator.length());
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = s;
        }
        return stringArray;
    }

    public static String join(String[] strings, String separator) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                out.append(separator);
            }
            out.append(strings[i]);
        }
        return out.toString();
    }

    public static String join(Iterable<String> strings, String separator) {
        StringBuilder out = new StringBuilder();
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            out.append(it.next());
            if (!it.hasNext()) continue;
            out.append(separator);
        }
        return out.toString();
    }

    public static String randomString(String characters, int length) {
        char[] chars = characters.toCharArray();
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int index = (int)(Math.random() * (double)chars.length);
            char c = chars[index];
            buffer.append(c);
        }
        return buffer.toString();
    }

    public static String padLeft(String s, char pad, int length) {
        StringBuilder b = new StringBuilder();
        for (int i = s.length(); i < length; ++i) {
            b.append(pad);
        }
        b.append(s);
        return b.toString();
    }

    public static String padRight(String s, char pad, int length) {
        StringBuilder b = new StringBuilder();
        b.append(s);
        for (int i = s.length(); i < length; ++i) {
            b.append(pad);
        }
        return b.toString();
    }

    public static int levenshteinDistance(String s, String t) {
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            char a = s.charAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                char b = t.charAt(j - 1);
                d[i][j] = StringUtil.minimum3(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + (a == b ? 0 : 1));
            }
        }
        return d[n][m];
    }

    private static int minimum3(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }
}

