/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import java.util.Iterator;
import net.psammead.util.ToString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntegerRange
implements Iterable<Integer> {
    public final int start;
    public final int end;
    public final int size;
    public final boolean forward;

    public static final IntegerRange range(int start, int end) {
        return new IntegerRange(start, end);
    }

    public IntegerRange(int start, int end) {
        this.start = start;
        this.end = end;
        this.size = end - start;
        this.forward = end >= start;
    }

    public boolean contains(int value) {
        return this.forward ? value >= this.start && value < this.end : value <= this.start && value > this.end;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntegerRangeIterator();
    }

    public String toString() {
        return new ToString(this).append("start", this.start).append("end", this.end).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.end;
        result = 31 * result + this.start;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerRange other = (IntegerRange)obj;
        if (this.end != other.end) {
            return false;
        }
        return this.start == other.start;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IntegerRangeIterator
    implements Iterator<Integer> {
        private int value;

        public IntegerRangeIterator() {
            this.value = IntegerRange.this.start;
        }

        @Override
        public boolean hasNext() {
            return IntegerRange.this.forward ? this.value < IntegerRange.this.end : this.value > IntegerRange.this.end;
        }

        @Override
        public Integer next() {
            int out = this.value;
            this.value += IntegerRange.this.forward ? 1 : -1;
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

