/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import net.psammead.util.Function;
import net.psammead.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Filters {
    private Filters() {
    }

    public static <VALUE> Function<VALUE, Boolean> all() {
        return new Function<VALUE, Boolean>(){

            @Override
            public Boolean apply(VALUE element) {
                return true;
            }
        };
    }

    public static <VALUE> Function<VALUE, Boolean> none() {
        return new Function<VALUE, Boolean>(){

            @Override
            public Boolean apply(VALUE element) {
                return false;
            }
        };
    }

    public static <VALUE> Function<VALUE, Boolean> not(final Function<VALUE, Boolean> sub) {
        return new Function<VALUE, Boolean>(){

            @Override
            public Boolean apply(VALUE element) {
                return (Boolean)sub.apply(element) == false;
            }
        };
    }

    public static <VALUE> Function<VALUE, Boolean> and(final Function<VALUE, Boolean> ... subs) {
        return new Function<VALUE, Boolean>(){

            @Override
            public Boolean apply(VALUE element) {
                for (Function sub : subs) {
                    if (((Boolean)sub.apply(element)).booleanValue()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static <VALUE> Function<VALUE, Boolean> or(final Function<VALUE, Boolean> ... subs) {
        return new Function<VALUE, Boolean>(){

            @Override
            public Boolean apply(VALUE element) {
                for (Function sub : subs) {
                    if (!((Boolean)sub.apply(element)).booleanValue()) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <VALUE> Function<VALUE, Boolean> equals(final VALUE value) {
        return new Function<VALUE, Boolean>(){

            @Override
            public Boolean apply(VALUE element) {
                return ObjectUtil.equals(element, value);
            }
        };
    }
}

