package net.psammead.util;

import net.psammead.util.Destroyable;
import net.psammead.util.Transformer;

public final class Struktors {
	private Struktors() {}
	
	public static <S,T> Struktor<S,T> nullify() {
		return new Struktor<S,T>() {
			public T create(S original) { return null; }
			public void delete(T derived) { }
		};
	}
	
	public static <S,T> Struktor<S,T> transformer(final Transformer<S,T> transformer) {
		return new Struktor<S,T>() {
			public T create(S original) { return transformer.transform(original); }
			public void delete(T derived) { }
		};
	}
	
	public static <S,T extends Destroyable> Struktor<S,T> destroyable(final Transformer<S,T> transformer) {
		return new Struktor<S,T>() {
			public T create(S original) { return transformer.transform(original); }
			public void delete(T derived) { derived.destroy(); }
		};
	}
}
