package net.psammead.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ListUtil {
	private ListUtil() {}
	
	public static <T> List<T> create(Iterable<T> in) {
		List<T> out	= new ArrayList<T>();
		for (T element : in)	out.add(element);
		return out;
	}
	
	public static <T,X extends T> List<T> single(X element) {
		List<T> out	= new ArrayList<T>();
		out.add(element);
		return out;
	}
	
	public static <T> List<T> filter(List<T> in, Filter<T> filter) {
		List<T> out	= new ArrayList<T>();
		for (T element : in) {
			if (filter.accept(element)) {
				out.add(element);
			}
		}
		return out;
	}
	 
	public static <T> List<T> union(List<T> a, List<T> b) {
		List<T> out	= new ArrayList<T>();
		out.addAll(a);
		out.addAll(b);
		return out;
	}
	
	public static <T> List<T> intersection(List<T> a, List<T> b) {
		List<T> out	= new ArrayList<T>();
		out.addAll(a);
		out.retainAll(b);
		return out;
	}
	
	public static <T> List<T> without(List<T> a, List<T> b) {
		List<T> out	= new ArrayList<T>();
		out.addAll(a);
		out.removeAll(b);
		return out;
	}
	
	public static <T> List<T> difference(List<T> a, List<T> b) {
		return without(union(a,b), intersection(a,b));
	}
	
	//-------------------------------------------------------------------------
	
	
	public static <T extends Comparable<? super T>> List<T> sort(List<T> in) {
		List<T> out	= new ArrayList<T>(in);
		Collections.sort(out);
		return out;
	}
	
	public static <T> List<T> sort(List<T> in, Comparator<T> comparator) {
		List<T> out	= new ArrayList<T>(in);
		Collections.sort(out, comparator);
		return out;
	} 
	
	public static <T> T first(List<T> list) {
		return list.get(0);
	}
	
	public static <T> T last(List<T> list) {
		return list.get(lastIndex(list));
	}
	
	public static int lastIndex(List<?> list) {
		return list.size()-1;
	} 
}
