package net.psammead.mwapi.yurik.json;

import java.text.ParseException;

import net.psammead.mwapi.yurik.IsoDateConverter;

public class IsoToDate implements JSONConverter {
	public Object convert(JSONConverterContext ctx, Object o) throws JSONConverterException {
		if (!(o instanceof String))	throw new JSONConverterException("expected a String: " + o);
		String	data	= (String)o;
		
		try {
			return IsoDateConverter.parseTimestamp(data);
		}
		catch (ParseException e) {
			throw new RuntimeException("### cannot parse", e);
		}
	}

}
