package net.psammead.mwapi.yurik;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.psammead.mwapi.NameSpace;
import net.psammead.util.StringUtil;

import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.util.EncodingUtil;

/** an easy way to put together arguments for a query to yurik's api */
public class YurikQuery {
	private static final String	FAKE_TRUE	= "yes";
	
	private Map<String,String>	args;
	
	public YurikQuery() {
		args	= new HashMap<String, String>();
	}
	
	//-------------------------------------------------------------------------
	//## input
	
	public void string(String key, String value) {
		if (value == null)	return;
		args.put(key, value);
	}
	
	public void number(String key, Number value) {
		if (value == null)	return;
		args.put(key, value.toString());
	}
	
	public void bool(String key, boolean value) {
		if (!value)	return;
		args.put(key, FAKE_TRUE);
	}
	
	public void date(String key, Date value) {
		if (value == null)	return;
		args.put(key, IsoDateConverter.formatTimestamp(value));
	}
	
	public void nameSpaces(String key, Iterable<NameSpace> value) {
		if (value == null)	return;
		List<String>	indizes	= new ArrayList<String>();
		for (NameSpace nameSpace : value)	indizes.add(""+nameSpace.index);
		String	str	= StringUtil.join(indizes, "|");
		args.put(key, str);
	}
	
	//-------------------------------------------------------------------------
	//## enums
	
	public void direction(String key, boolean newerNotOlder) {
		if (newerNotOlder)	args.put(key, "newer");
		else				args.put(key, "older");
	}
	
	public void protocol(String key, String value) {
		if (value == null)	return;
		if (!value.matches("http|https|ftp|irc|gopher|telnet|nntp|worldwind|mailto|news"))
			throw new IllegalArgumentException(key + " must be one of http, https, ftp, irc, gopher, telnet, nntp, worldwind, mailto, news: " + value);
		args.put(key, value);
	}

	public void filterRedir(String key, String value) {
		if (value == null)	return;
		if (!value.matches("all|redirects|nonredirects"))
			throw new IllegalArgumentException(key + " must be one of all, redirects, nonredirects: " + value);
		args.put(key, value);
	}
	
	public void group(String key, String value) {
		if (value == null)	return;
		if (!value.matches("bot|sysop|bureaucrat|checkuser|steward|boardvote|import|developer|oversight"))
			throw new IllegalArgumentException(key + " must be one of bot, sysop, bureaucrat, checkuser, steward, boardvote, import, developer, oversight: " + value);
		args.put(key, value);
	}
	
	public void limit(String key, int value, int maximum) {
		if (value > maximum)	throw new IllegalArgumentException("limit may not exceed " + maximum);
		args.put(key, ""+value);
	}
	
	//-------------------------------------------------------------------------
	//## output
	
	public String toQueryString(String charSet) {
		return EncodingUtil.formUrlEncode(toNameValuePairs(), charSet);
	}
	
	public NameValuePair[] toNameValuePairs() {
		List<NameValuePair>	list	= new ArrayList<NameValuePair>();
		for (Map.Entry<String, String> arg : args.entrySet()) {
			list.add(new NameValuePair(
					arg.getKey(), 
					arg.getValue()));
		}
		return list.toArray(new NameValuePair[list.size()]);
	}
}
