/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class RatioLayout
implements LayoutManager {
    public static final String FIRST = "FIRST";
    public static final String SECOND = "SECOND";
    private final boolean horizontal;
    private final int gap;
    private final double ratio;
    private Component first;
    private Component second;

    public static RatioLayout horizontal(double ratio, int gap) {
        return new RatioLayout(true, ratio, gap);
    }

    public static RatioLayout vertical(double ratio, int gap) {
        return new RatioLayout(false, ratio, gap);
    }

    public RatioLayout(boolean horizontal, double ratio, int gap) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("precondition violated: 0.0 <= ratio <= 1.0");
        }
        if (gap < 0) {
            throw new IllegalArgumentException("precondition violated: gap >= 0");
        }
        this.horizontal = horizontal;
        this.ratio = ratio;
        this.gap = gap;
    }

    public void addLayoutComponent(String constraint, Component c) {
        if (FIRST.equals(constraint)) {
            this.first = c;
        } else if (SECOND.equals(constraint)) {
            this.second = c;
        } else {
            throw new IllegalArgumentException("only FIRST and SECOND are allowed contraint values");
        }
    }

    public void removeLayoutComponent(Component c) {
        if (this.first == c) {
            this.first = null;
        }
        if (this.second == c) {
            this.second = null;
        }
    }

    public Dimension preferredLayoutSize(Container c) {
        return this.minimumLayoutSize(c);
    }

    public Dimension minimumLayoutSize(Container c) {
        if (this.first == null && this.second == null) {
            return new Dimension(0, 0);
        }
        if (this.first != null && this.second == null) {
            return this.first.getMinimumSize();
        }
        if (this.first == null && this.second != null) {
            return this.second.getMinimumSize();
        }
        if (this.horizontal) {
            Dimension min1 = this.first.getMinimumSize();
            Dimension min2 = this.second.getMinimumSize();
            int split1 = min1.width;
            int split2 = min2.width;
            int added = split1 + this.gap + split2;
            int more1 = (int)((double)split1 / this.ratio + (double)this.gap);
            int more2 = (int)((double)split2 / (1.0 - this.ratio) + (double)this.gap);
            int split = Math.max(added, Math.max(more1, more2));
            int keep1 = min1.height;
            int keep2 = min2.height;
            int keep = Math.max(keep1, keep2);
            return new Dimension(split, keep);
        }
        Dimension min1 = this.first.getMinimumSize();
        Dimension min2 = this.second.getMinimumSize();
        int split1 = min1.height;
        int split2 = min2.height;
        int added = split1 + this.gap + split2;
        int more1 = (int)((double)split1 / this.ratio + (double)this.gap);
        int more2 = (int)((double)split2 / (1.0 - this.ratio) + (double)this.gap);
        int split = Math.max(added, Math.max(more1, more2));
        int keep1 = min1.width;
        int keep2 = min2.width;
        int keep = Math.max(keep1, keep2);
        return new Dimension(keep, split);
    }

    public void layoutContainer(Container c) {
        Dimension size = c.getSize();
        Insets insets = c.getInsets();
        Rectangle bounds = new Rectangle(insets.left, insets.bottom, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        if (this.first != null || this.second != null) {
            if (this.first != null && this.second == null) {
                this.first.setBounds(bounds);
            } else if (this.first == null && this.second != null) {
                this.second.setBounds(bounds);
            } else if (this.horizontal) {
                int div = (int)((double)(bounds.width - this.gap) * this.ratio);
                this.first.setBounds(bounds.x, bounds.y, div, bounds.height);
                this.second.setBounds(div + this.gap, bounds.y, bounds.width - div - this.gap, bounds.height);
            } else {
                int div = (int)((double)(bounds.height - this.gap) * this.ratio);
                this.first.setBounds(bounds.x, bounds.y, bounds.width, div);
                this.second.setBounds(bounds.x, div + this.gap, bounds.width, bounds.height - div - this.gap);
            }
        }
    }
}

