/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.apple;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.psammead.util.Logger;

public class AppleQuit {
    private static final Logger log = new Logger(System.err, AppleQuit.class);

    private AppleQuit() {
    }

    public static void install(final AppleQuitHandler handler) {
        try {
            Class<?> utilsClass = Class.forName("com.apple.mrj.MRJApplicationUtils");
            Class<?> handlerClass = Class.forName("com.apple.mrj.MRJQuitHandler");
            Object adapterInstance = Proxy.newProxyInstance(AppleQuit.class.getClassLoader(), new Class[]{handlerClass}, new InvocationHandler(){

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    log.info("apple quithandler executing");
                    handler.applicationQuit();
                    return null;
                }
            });
            Method registerMethod = utilsClass.getMethod("registerQuitHandler", handlerClass);
            registerMethod.invoke(null, adapterInstance);
            log.info("apple quithandler installed");
        }
        catch (ClassNotFoundException e) {
            log.info("apple quithandler not installed");
        }
        catch (Exception e) {
            log.error("cannot install apple quithandler", e);
        }
    }

    public static interface AppleQuitHandler {
        public void applicationQuit();
    }
}

