/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

import net.psammead.util.Scan;

public final class XMLCodec {
    private XMLCodec() {
    }

    public static String encode(String s, boolean quot, boolean apos) {
        StringBuilder out = new StringBuilder();
        int len = s.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '&': {
                    out.append("&amp;");
                    continue block7;
                }
                case '<': {
                    out.append("&lt;");
                    continue block7;
                }
                case '>': {
                    out.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    out.append(quot ? "&quot;" : Character.valueOf(c));
                    continue block7;
                }
                case '\'': {
                    out.append(apos ? "&apos;" : Character.valueOf(c));
                    continue block7;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    public static String decode(String s, boolean quot, boolean apos) throws IllegalArgumentException {
        Scan tok = new Scan(s);
        StringBuilder out = new StringBuilder();
        while (!tok.isFinished()) {
            out.append(tok.scan("&"));
            if (tok.isFinished()) break;
            if (tok.is("&amp;")) {
                out.append('&');
                continue;
            }
            if (tok.is("&lt;")) {
                out.append('<');
                continue;
            }
            if (tok.is("&gt;")) {
                out.append('>');
                continue;
            }
            if (quot && tok.is("&quot;")) {
                out.append('\"');
                continue;
            }
            if (apos && tok.is("&apos;")) {
                out.append('\'');
                continue;
            }
            if (!tok.is("&")) continue;
            out.append('&');
        }
        return out.toString();
    }
}

