/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util;

public final class Base64Codec {
    private static final char TERMINATOR = '=';
    private static final int WIDTH = 76;
    private static final char[] EN_TABLE;
    private static final byte[] DE_TABLE;

    private Base64Codec() {
    }

    public static String encodeStr(String data) {
        return Base64Codec.encode(data.getBytes());
    }

    public static String decodeStr(String data) {
        return new String(Base64Codec.decode(data));
    }

    public static String encode(byte[] data) {
        int len = data.length;
        int packets = len / 3;
        String s = "";
        int idx = 0;
        for (int i = 0; i < packets; ++i) {
            s = s + EN_TABLE[data[idx + 0] >> 2 & 0x3F];
            s = s + EN_TABLE[data[idx + 0] << 4 & 0x30 | data[idx + 1] >> 4 & 0xF];
            s = s + EN_TABLE[data[idx + 1] << 2 & 0x3C | data[idx + 2] >> 6 & 3];
            s = s + EN_TABLE[data[idx + 2] & 0x3F];
            idx += 3;
        }
        switch (len % 3) {
            case 1: {
                s = s + EN_TABLE[data[idx + 0] >> 2 & 0x3F];
                s = s + EN_TABLE[data[idx + 0] << 4 & 0x30];
                s = s + '=';
                s = s + '=';
                break;
            }
            case 2: {
                s = s + EN_TABLE[data[idx + 0] >> 2 & 0x3F];
                s = s + EN_TABLE[data[idx + 0] << 4 & 0x30 | data[idx + 1] >> 4 & 0xF];
                s = s + EN_TABLE[data[idx + 1] << 2 & 0x3C];
                s = s + '=';
            }
        }
        return s;
    }

    public static byte[] decode(String text) {
        if (text.length() == 0) {
            return new byte[0];
        }
        char[] in = text.toCharArray();
        int ilen = in.length;
        int olen = (ilen + 3) / 4 * 3;
        if (in[ilen - 1] == '=') {
            --olen;
        }
        if (in[ilen - 2] == '=') {
            --olen;
        }
        byte[] out = new byte[olen];
        int shift = 0;
        int akku = 0;
        int op = 0;
        for (int i = 0; i < ilen; ++i) {
            byte value = DE_TABLE[in[i]];
            if (value < 0) continue;
            akku <<= 6;
            akku |= value;
            if ((shift += 6) < 8) continue;
            out[op++] = (byte)(akku >> (shift -= 8) & 0xFF);
        }
        return out;
    }

    public static String stripGarbage(String data) {
        int i;
        String str = "";
        int len = data.length();
        char c = '\u0000';
        int x = -1;
        for (i = 0; i < len; ++i) {
            c = data.charAt(i);
            x = DE_TABLE[c];
            if (x >= 0) {
                str = str + c;
                continue;
            }
            if (x == -2) break;
        }
        while (i < len && x == -2) {
            str = str + c;
            c = data.charAt(++i);
            x = DE_TABLE[c];
        }
        return str;
    }

    public static String insertCRLF(String code) {
        String s = "";
        int len = code.length();
        int lines = len / 76;
        int index = 0;
        for (int i = 0; i < lines; ++i) {
            s = s + code.substring(index, index + 76) + "\r\n";
            index += 76;
        }
        int left = len % 76;
        if (left > 0) {
            s = s + code.substring(len - left) + "\r\n";
        }
        return s;
    }

    static {
        int i;
        EN_TABLE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        DE_TABLE = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64Codec.DE_TABLE[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64Codec.DE_TABLE[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64Codec.DE_TABLE[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64Codec.DE_TABLE[i] = (byte)(52 + i - 48);
        }
        Base64Codec.DE_TABLE[43] = 62;
        Base64Codec.DE_TABLE[47] = 63;
        Base64Codec.DE_TABLE[61] = -2;
    }
}

