/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.minibpp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import net.psammead.minibpp.Context;
import net.psammead.minibpp.parser.ParseException;
import net.psammead.minibpp.parser.Parser;

public class Compiler {
    private int depth;
    private int lineNumber;
    private char echoChar = (char)35;
    private char exactCmd = (char)39;
    private char magicCmd = (char)34;
    private char defaultCmd = (char)34;
    private char magicIdentifier = (char)36;

    public static void main(String[] stringArray) throws ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        Compiler compiler = new Compiler();
        compiler.filter(bufferedReader, printWriter);
        bufferedReader.close();
        printWriter.close();
    }

    public Compiler() {
        this(1);
    }

    public Compiler(int n) {
        this.depth = n;
        this.lineNumber = 0;
    }

    public String compile(Reader reader) throws ParseException, IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.filter(bufferedReader, printWriter);
        printWriter.close();
        return stringWriter.toString();
    }

    public String compile(String string) throws ParseException, IOException {
        StringReader stringReader = new StringReader(string);
        String string2 = this.compile(stringReader);
        ((Reader)stringReader).close();
        return string2;
    }

    public String compile(File file, String string) throws ParseException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), string);
        String string2 = this.compile(inputStreamReader);
        ((Reader)inputStreamReader).close();
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(File file, File file2, String string) throws ParseException, IOException {
        BufferedReader bufferedReader = null;
        PrintWriter printWriter = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string));
            this.filter(bufferedReader, printWriter);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            if (printWriter != null) {
                try {
                    printWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void filter(BufferedReader bufferedReader, PrintWriter printWriter) throws ParseException, IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            this.decorate(string, printWriter);
        }
    }

    public int getLine() {
        return this.lineNumber;
    }

    private void decorate(String string, PrintWriter printWriter) throws ParseException, IOException {
        String string2;
        char c;
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == this.echoChar; ++n) {
        }
        if (n >= this.depth) {
            this.echo(string, printWriter);
            return;
        }
        if (n == this.depth - 1 && string.length() > n) {
            c = string.charAt(n);
            if (c == this.exactCmd || c == this.magicCmd) {
                string2 = string.substring(0, n) + string.substring(n + 1);
            } else {
                c = this.defaultCmd == this.magicCmd && this.hasMagic(string) ? this.magicCmd : this.exactCmd;
                string2 = string;
            }
        } else {
            c = this.exactCmd;
            string2 = string;
        }
        if (c == this.exactCmd || !this.hasMagic(string2)) {
            this.exact(string2, printWriter);
        } else {
            this.magic(string2, printWriter);
        }
    }

    private void exact(String string, PrintWriter printWriter) throws IOException {
        printWriter.print("out.println(");
        printWriter.print(Compiler.literal(string));
        printWriter.println(");");
    }

    private void magic(String string, PrintWriter printWriter) throws ParseException, IOException {
        Context context = new Context(printWriter);
        Parser.parse(new StringReader(string), context);
    }

    private void echo(String string, PrintWriter printWriter) throws IOException {
        String string2 = string.substring(this.depth);
        printWriter.println(string2);
    }

    private boolean hasMagic(String string) {
        return string.indexOf(this.magicIdentifier) >= 0;
    }

    static String literal(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        block9: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block9;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block9;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block9;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block9;
                }
                default: {
                    if (c >= ' ' && c < '\u007f') {
                        stringBuffer.append(c);
                        continue block9;
                    }
                    stringBuffer.append("\\u");
                    String string2 = Integer.toHexString(c);
                    int n = string2.length();
                    while (n < 4) {
                        stringBuffer.append('0');
                        ++i;
                    }
                    stringBuffer.append(string2);
                }
            }
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

