/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.yurik.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.psammead.mwapi.yurik.json.JSONConverter;
import net.psammead.mwapi.yurik.json.JSONConverterContext;
import net.psammead.mwapi.yurik.json.JSONConverterException;
import net.psammead.mwapi.yurik.json.MapEntry;
import net.psammead.util.DebugUtil;
import net.psammead.util.reflect.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateObj
implements JSONConverter {
    public static boolean debug = false;
    private final Class<?> clazz;
    private List<JSONConverter> params;

    public CreateObj(Class<?> clazz, JSONConverter ... params) {
        this.clazz = clazz;
        this.params = Arrays.asList(params);
    }

    @Override
    public Object convert(JSONConverterContext ctx, Object o) throws JSONConverterException {
        this.debug("converting: " + this.clazz);
        this.printUnusedData(o);
        try {
            ArrayList<Object> args = new ArrayList<Object>();
            for (JSONConverter param : this.params) {
                Object arg = param.convert(ctx, o);
                args.add(arg);
                this.debug("carg: " + DebugUtil.shortClassName((Object)arg) + "\t" + arg);
            }
            return ReflectUtil.object(this.clazz, (Object[])args.toArray());
        }
        catch (Exception e) {
            throw new JSONConverterException("cannot convert to " + this.clazz, e);
        }
    }

    private void printUnusedData(Object o) {
        if (!debug) {
            return;
        }
        if (!(o instanceof Map)) {
            return;
        }
        Map data = (Map)o;
        HashSet unused = new HashSet(data.keySet());
        for (JSONConverter param : this.params) {
            if (!(param instanceof MapEntry)) continue;
            MapEntry entry = (MapEntry)param;
            unused.remove(entry.key);
        }
        if (unused.isEmpty()) {
            return;
        }
        this.debug("not mapped: " + unused);
    }

    private void debug(String s) {
        if (!debug) {
            return;
        }
        System.err.println(DebugUtil.shortClassName((Object)this) + "\t" + s);
    }
}

