/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.config;

import java.util.List;
import net.psammead.mwapi.config.Family;
import net.psammead.mwapi.config.Site;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigSerializer {
    public static String serializeFamliyList(List<String> families) {
        StringBuffer out = new StringBuffer();
        for (String s : families) {
            out.append(s).append("\n");
        }
        return out.toString();
    }

    public static String serializeFamily(Family family) {
        String out = "## configuration for a whole wiki family\n\n";
        out = out + "# identification\n";
        out = out + "name\t" + family.name + "\n";
        if (family.shortcut != null) {
            out = out + "shortcut\t" + family.shortcut + "\n";
        }
        out = out + "\n";
        out = out + "# languages\n";
        out = out + "multilingual\t" + family.multilingual + "\n";
        if (family.multilingual) {
            out = out + "defaultLanguage\t" + family.defaultLanguage + "\n";
            for (String supportedLanguage : family.supportedLanguages) {
                out = out + "supportedLanguage\t" + supportedLanguage + "\n";
            }
        }
        return out;
    }

    public static String serializeSite(Site site) {
        String value;
        String out = "## configuration for a single wiki site\n\n";
        out = out + "# identification\n";
        out = out + "family\t" + site.family + "\n";
        if (site.language != null) {
            out = out + "language\t" + site.language + "\n";
        }
        out = out + "\n";
        out = out + "# network\n";
        out = out + "protocol\t" + site.protocol + "\n";
        out = out + "hostName\t" + site.hostName + "\n";
        out = out + "rawPath\t" + site.rawPath + "\n";
        out = out + "prettyPath\t" + site.prettyPath + "\n";
        out = out + "apiPath\t" + site.apiPath + "\n";
        out = out + "\n";
        out = out + "# config\n";
        out = out + "charSet\t" + site.charSet + "\n";
        out = out + "titleCase\t" + site.titleCase + "\n";
        out = out + "uselang\t" + site.uselang + "\n";
        out = out + "\n";
        out = out + "# nameSpaces\n";
        for (Integer n : site.nameSpaceNames.keySet()) {
            value = site.nameSpaceNames.get(n);
            out = out + "nameSpace\t" + n + "\t" + ConfigSerializer.quoteMessage(value) + "\n";
        }
        out = out + "\n";
        out = out + "# specialPages\n";
        for (String string : site.specialPageNames.keySet()) {
            value = site.specialPageNames.get(string);
            out = out + "specialPage\t" + ConfigSerializer.quoteMessage(string) + "\t" + ConfigSerializer.quoteMessage(value) + "\n";
        }
        out = out + "\n";
        out = out + "# messages\n";
        for (String string : site.messages.keySet()) {
            value = site.messages.get(string);
            out = out + "message\t" + string + "\t" + ConfigSerializer.quoteMessage(value) + "\n";
        }
        return out;
    }

    public static String quoteMessage(String message) {
        return "'" + message.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'").replaceAll("\n", "\\\\n") + "'";
    }
}

