/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi;

import net.psammead.mwapi.connection.TitleUtil;
import net.psammead.util.ToString;

public class NameSpace {
    public static final int MEDIA = -2;
    public static final int SPECIAL = -1;
    public static final int ARTICLE = 0;
    public static final int ARTICLE_TALK = 1;
    public static final int USER = 2;
    public static final int USER_TALK = 3;
    public static final int PROJECT = 4;
    public static final int PROJECT_TALK = 5;
    public static final int IMAGE = 6;
    public static final int IMAGE_TALK = 7;
    public static final int MEDIAWIKI = 8;
    public static final int MEDIAWIKI_TALK = 9;
    public static final int TEMPLATE = 10;
    public static final int TEMPLATE_TALK = 11;
    public static final int HELP = 12;
    public static final int HELP_TALK = 13;
    public static final int CATEGORY = 14;
    public static final int CATEGORY_TALK = 15;
    public static final int FREE = 100;
    private static final String[] CANONICAL = new String[]{"Media", "Special", "", "Talk", "User", "User talk", "Project", "Project talk", "Image", "Image talk", "MediaWiki", "MediaWiki talk", "Template", "Template talk", "Help", "Help talk", "Category", "Categoy talk"};
    public final int index;
    public final String name;
    private NameSpace discussionTwin;

    public static String canonical(int index) {
        return TitleUtil.underscores(CANONICAL[index - -2]);
    }

    public NameSpace(int index, String name) {
        this.index = index;
        this.name = TitleUtil.underscores(name);
    }

    public boolean isArticle() {
        return this.index == 0;
    }

    public boolean isSpecial() {
        return this.index < 0;
    }

    public boolean isRegular() {
        return this.index >= 0 && this.index % 2 == 0;
    }

    public boolean isDiscussion() {
        return this.index >= 0 && this.index % 2 == 1;
    }

    public boolean matches(String title) {
        title = TitleUtil.underscores(title);
        return title.startsWith(this.name + ":");
    }

    public String addTo(String title) {
        if (this.isArticle()) {
            return title;
        }
        return TitleUtil.spaces(this.name) + ":" + title;
    }

    public String removeFrom(String title) {
        if (this.isArticle()) {
            return title;
        }
        if (!this.matches(title)) {
            throw new IllegalArgumentException("cannot remove namespace " + this.name + " from title " + title);
        }
        return title.substring(this.name.length() + 1);
    }

    public NameSpace toggleDiscussion() {
        return this.discussionTwin;
    }

    public void setDiscussionTwin(NameSpace discussionTwin) {
        this.discussionTwin = discussionTwin;
    }

    public String toString() {
        return new ToString((Object)this).append("index", (Object)this.index).append("name", (Object)this.name).toString();
    }
}

