package net.psammead.mwapi.config;

import java.util.Iterator;
import java.util.List;

/** stores FamilyList, Families and Sites into Strings */
public class ConfigSerializer {
	public static String serializeFamliyList(List<String> families) {
		StringBuffer out = new StringBuffer();
		for (Iterator<String> it = families.iterator(); it.hasNext();) {
			String s = it.next();
			out.append(s).append(ConfigInfo.EOL);
		}
		return out.toString();
	}
	
	public static String serializeFamily(Family family) {
		String	out	= "## configuration for a whole wiki family\n\n";
					
		out	+= "# identification"							+ "\n";
		out	+= "name\t"				+	family.name			+ "\n";
		if (family.shortcut != null)
		out	+= "shortcut\t"			+	family.shortcut		+ "\n";
		out	+= "\n";
					
		out	+= "# languages"								+ "\n";
		out	+= "multilingual\t"		+	family.multilingual	+ "\n";
		
		if (family.multilingual) {
			// the first language is the default language
			out	+= "defaultLanguage\t" + family.defaultLanguage		+ "\n";
			for (Iterator<String> it = family.supportedLanguages.iterator(); it.hasNext();) {
				String supportedLanguage = it.next();
				out	+= "supportedLanguage\t" + supportedLanguage	+ "\n";
			}
		}
		
		return out;
	}
	
	public static String serializeSite(Site site) {
		String	out	= "## configuration for a single wiki site\n\n";
		
		out	+= "# identification"	+ "\n";
		out	+= "family\t"		+ site.family		+ "\n";
		if (site.language != null)
		out	+= "language\t"		+ site.language		+ "\n";
		out	+= "\n";

		out	+= "# network"							+ "\n";
		out	+= "protocol\t"		+ site.protocol		+ "\n";
		out	+= "hostName\t"		+ site.hostName		+ "\n";
		out	+= "rawPath\t"		+ site.rawPath		+ "\n";
		out	+= "prettyPath\t"	+ site.prettyPath	+ "\n";
		out	+= "apiPath\t"		+ site.apiPath		+ "\n";
		out	+= "\n";
		
		out	+= "# config"							+ "\n";
		out	+= "charSet\t"		+ site.charSet		+ "\n";
		out	+= "titleCase\t"	+ site.titleCase	+ "\n";
		out	+= "uselang\t"		+ site.uselang		+ "\n";
		out	+= "\n";
		
		out	+= "# nameSpaces\n";
		for (Iterator<Integer> it = site.nameSpaceNames.keySet().iterator(); it.hasNext();) {
			Integer key 	= it.next();
			String	value	= site.nameSpaceNames.get(key);
			out	+= "nameSpace\t" + key + "\t" + quoteMessage(value) + "\n";
		}
		out	+= "\n";
		
		out	+= "# specialPages\n";
		for (Iterator<String> it = site.specialPageNames.keySet().iterator(); it.hasNext();) {
			String	key 	= it.next();
			String	value	= site.specialPageNames.get(key);
			out	+= "specialPage\t" + quoteMessage(key) + "\t" + quoteMessage(value) + "\n";
		}
		out	+= "\n";
		
		out	+= "# messages\n";
		for (Iterator<String> it = site.messages.keySet().iterator(); it.hasNext();) {
			String	key 	= it.next();
			String	value	= site.messages.get(key);
			out	+= "message\t" + key + "\t" + quoteMessage(value) + "\n";
		}

		return out;
	}
	
	public static String quoteMessage(String message) {
		return "'"
			+ message.replaceAll("\\\\", "\\\\\\\\")
					.replaceAll("'", "\\\\'")
					.replaceAll("\n", "\\\\n")
			+ "'";
	}
}
