package net.psammead.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

/**
 * <code>
 *	import java.awt.event.ActionEvent;
 *	import java.awt.event.ActionListener;
 * 
 *	public class AnnouncerTest {
 *		public static void main(String[] args) {
 *			new AnnouncerTest().run();
 *		}
 * 	
 *		final Announcer<ActionListener>	announcer	= Announcer.to(ActionListener.class);
 * 	
 *		void run() {
 * 			announcer.addListener(new ActionListener() {
 * 				public void actionPerformed(ActionEvent ev) {
 * 					System.err.println("announced: " + ev);
 * 				}
 * 			});
 * 		
 * 			announcer.send.actionPerformed(new ActionEvent(announcer, 0, null));
 * 		}
 *	}
 * </code> 
 */
public final class Announcer<LISTENER extends EventListener> {
	public static <T extends EventListener> Announcer<T> to(Class<? extends T> listenerType) {
		return new Announcer<T>(listenerType);
	}

	public final LISTENER	send;
	
	private final List<LISTENER>	listeners;
	
	public Announcer(Class<? extends LISTENER> listenerType) {
		listeners	= new ArrayList<LISTENER>();
		send	= listenerType.cast(Proxy.newProxyInstance(
			getClass().getClassLoader(), 
			new Class<?>[]{listenerType}, 
			new InvocationHandler() {
				public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
					announce(method, args);
					return null;
				}
			}
		));
	}
	
	public synchronized void addListener(LISTENER listener) {
		listeners.add(listener);
	}
	
	public synchronized void removeListener(LISTENER listener) {
		listeners.remove(listener);
	}
	
	private synchronized List<LISTENER>	clonedListeners() {
		return new ArrayList<LISTENER>(listeners);
	}

//	public T announce() {
//		return announce;
//	}

	private void announce(Method m, Object[] args) {
		try {
			for (LISTENER listener : clonedListeners()) {
				m.invoke(listener, args);
			}
		}
		catch (IllegalAccessException e) {
			throw new IllegalArgumentException("could not invoke listener", e);
		}
		catch (InvocationTargetException e) {
			Throwable cause = e.getCause();
			
			if (cause instanceof RuntimeException) {
				throw (RuntimeException)cause;
			} 
			else if (cause instanceof Error) {
				throw (Error)cause;
			}
			else {
				throw new UnsupportedOperationException("listener threw exception", cause);
			}
		}
	}
}
