package net.psammead.commonist.ui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import net.psammead.commonist.util.*;

/** the application window */
public class MainWindow {
	public final  JFrame	window;
	
	// components
	private JPanel	topPanel;
	
	/** action events this UI sends */
	public interface Callback {
		void quit();
	}

	/** contains all UIs */
	public MainWindow(CommonUI commonUI, DirectoryUI directoryUI, 
			ImageListUI imageListUI, StatusUI statusUI, UploadUI uploadUI, 
			String programHeading, Image programIcon, final Callback callback) {
		//------------------------------------------------------------------------------
		//## panels
		
		JPanel	leftPanel	= new JPanel();
		leftPanel.setLayout(new BorderLayout());
		leftPanel.add(commonUI.getComponent(),		BorderLayout.NORTH);	// "at 0/0 size 1/1 weight 1/0 anchor center fill horizontal insets 0/0/0/0");
		leftPanel.add(directoryUI.getComponent(),	BorderLayout.CENTER);	// "at 0/1 size 1/1 weight 1/1 anchor center fill both insets 0/0/0/0");
		
		topPanel	= new JPanel();
		topPanel.setLayout(new BorderLayout());
		topPanel.add(leftPanel, BorderLayout.CENTER);
		topPanel.add(imageListUI.getComponent(), BorderLayout.EAST);
		
		JPanel	bottomPanel	= new JPanel();
		bottomPanel.setLayout(new BorderLayout());
		bottomPanel.add(statusUI.getComponent(), BorderLayout.CENTER);
		bottomPanel.add(uploadUI.getComponent(), BorderLayout.EAST);
		
		JPanel	windowPanel	= new JPanel();
		windowPanel.setLayout(new BorderLayout());
		windowPanel.add(topPanel, BorderLayout.CENTER);
		windowPanel.add(bottomPanel, BorderLayout.SOUTH);
		
		//------------------------------------------------------------------------------
		//## frame
		
		window	= new JFrame(programHeading);
		window.setIconImage(programIcon);
		window.getContentPane().add(windowPanel);
		window.pack();
		window.setSize(new Dimension(800, 600));
		window.setDefaultCloseOperation(WindowConstants.DO_NOTHING_ON_CLOSE);	// EXIT_ON_CLOSE or DISPOSE_ON_CLOSE;
		
		window.setLocationRelativeTo(null);
		
		// quit on window close 
		window.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent ev) {
				window.dispose();
				// global
				callback.quit();
			}
		});
	}
	
	/** should be called after loadProperties */
	public void makeVisible() {
		window.setVisible(true);
	}

	/** call when ImageUIs have been added or removed */
	public void revalidate() {
		topPanel.revalidate();
	}
	
	//------------------------------------------------------------------------------
	//## Settings

	/** loads this UI's state from the properties */
	public void loadSettings(Settings settings) {
		Rectangle	bounds	= window.getBounds();
		bounds.x		= Integer.parseInt(settings.get("mainUI.x", ""+bounds.x));
		bounds.y		= Integer.parseInt(settings.get("mainUI.y", ""+bounds.y));
		bounds.width	= Integer.parseInt(settings.get("mainUI.w", ""+bounds.width));
		bounds.height	= Integer.parseInt(settings.get("mainUI.h", ""+bounds.height));
        UIUtil.limitAndChangeBounds(window, bounds);
	}
	
	/** stores this UI's state in the properties */
	public void saveSettings(Settings settings) {
		Rectangle	bounds	= window.getBounds();
		settings.set("mainUI.x",	""+bounds.x);
		settings.set("mainUI.y",	""+bounds.y);
		settings.set("mainUI.w",	""+bounds.width);
		settings.set("mainUI.h",	""+bounds.height);
	}
}
