/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.util.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JLabel;

public final class GridBagConstraintsBuilder {
    private GridBagConstraints c;

    public static void main(String[] args) {
        JLabel label1 = new JLabel("hallo");
        JLabel label2 = new JLabel("welt");
        label1.setBackground(Color.red);
        label2.setBackground(Color.green);
        label1.setOpaque(true);
        label2.setOpaque(true);
        JFrame frame = new JFrame("GridBagConstraintsBuilder");
        Container content = frame.getContentPane();
        content.setLayout(new GridBagLayout());
        content.add((Component)label1, new GridBagConstraintsBuilder().pos(0, 0).size(1, 1).weight(0.0, 0.0).fillNone().insetsLeft(5).done());
        content.add((Component)label2, new GridBagConstraintsBuilder().pos(1, 0).size(1, 1).weight(1.0, 0.0).fillHorizontal().insetsLeft(5).insetsRight(5).done());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public GridBagConstraintsBuilder() {
        this.c = new GridBagConstraints();
    }

    public GridBagConstraintsBuilder(GridBagConstraints constraints) {
        this.c = constraints;
    }

    public GridBagConstraints done() {
        return this.c;
    }

    public GridBagConstraintsBuilder reset() {
        GridBagConstraintsBuilder.reset(this.c);
        return this;
    }

    public GridBagConstraintsBuilder load(GridBagConstraints constraints) {
        GridBagConstraintsBuilder.copy(constraints, this.c);
        return this;
    }

    public GridBagConstraintsBuilder store(GridBagConstraints constraints) {
        GridBagConstraintsBuilder.copy(this.c, constraints);
        return this;
    }

    public GridBagConstraintsBuilder pos(int x, int y) {
        return this.posX(x).posY(y);
    }

    public GridBagConstraintsBuilder posRelative() {
        return this.posRelativeX().posRelativeY();
    }

    public GridBagConstraintsBuilder posX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("expected x >= 0");
        }
        this.c.gridx = x;
        return this;
    }

    public GridBagConstraintsBuilder posY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("expected y >= 0");
        }
        this.c.gridy = y;
        return this;
    }

    public GridBagConstraintsBuilder posRelativeX() {
        this.c.gridx = -1;
        return this;
    }

    public GridBagConstraintsBuilder posRelativeY() {
        this.c.gridy = -1;
        return this;
    }

    public GridBagConstraintsBuilder size(int x, int y) {
        return this.sizeX(x).sizeY(x);
    }

    public GridBagConstraintsBuilder sizeRelative() {
        return this.sizeRelativeX().sizeRelativeY();
    }

    public GridBagConstraintsBuilder sizeRemainder() {
        return this.sizeRemainderX().sizeRemainderY();
    }

    public GridBagConstraintsBuilder sizeX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("expected x >= 0");
        }
        this.c.gridwidth = x;
        return this;
    }

    public GridBagConstraintsBuilder sizeY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("expected y >= 0");
        }
        this.c.gridheight = y;
        return this;
    }

    public GridBagConstraintsBuilder sizeRelativeX() {
        this.c.gridwidth = -1;
        return this;
    }

    public GridBagConstraintsBuilder sizeRelativeY() {
        this.c.gridheight = -1;
        return this;
    }

    public GridBagConstraintsBuilder sizeRemainderX() {
        this.c.gridwidth = 0;
        return this;
    }

    public GridBagConstraintsBuilder sizeRemainderY() {
        this.c.gridheight = 0;
        return this;
    }

    public GridBagConstraintsBuilder weight(double x, double y) {
        return this.weightX(x).weightY(y);
    }

    public GridBagConstraintsBuilder weightX(double x) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("expected 0 <= x <= 1");
        }
        this.c.weightx = x;
        return this;
    }

    public GridBagConstraintsBuilder weightY(double y) {
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("expected 0 <= y <= 1");
        }
        this.c.weighty = y;
        return this;
    }

    public GridBagConstraintsBuilder ipad(int x, int y) {
        return this.ipadX(x).ipadY(y);
    }

    public GridBagConstraintsBuilder ipadX(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("expected x >= 0");
        }
        this.c.ipadx = x;
        return this;
    }

    public GridBagConstraintsBuilder ipadY(int y) {
        if (y < 0) {
            throw new IllegalArgumentException("expected y >= 0");
        }
        this.c.ipady = y;
        return this;
    }

    public GridBagConstraintsBuilder insets(int top, int left, int bottom, int right) {
        return this.insetsTop(top).insetsLeft(left).insetsBottom(bottom).insetsRight(right);
    }

    public GridBagConstraintsBuilder insetsTop(int top) {
        if (top < 0) {
            throw new IllegalArgumentException("expected top >= 0");
        }
        Insets old = this.c.insets;
        this.c.insets = new Insets(top, old.left, old.bottom, old.right);
        return this;
    }

    public GridBagConstraintsBuilder insetsLeft(int left) {
        if (left < 0) {
            throw new IllegalArgumentException("expected left >= 0");
        }
        Insets old = this.c.insets;
        this.c.insets = new Insets(old.top, left, old.bottom, old.right);
        return this;
    }

    public GridBagConstraintsBuilder insetsBottom(int bottom) {
        if (bottom < 0) {
            throw new IllegalArgumentException("expected bottom >= 0");
        }
        Insets old = this.c.insets;
        this.c.insets = new Insets(old.top, old.left, bottom, old.right);
        return this;
    }

    public GridBagConstraintsBuilder insetsRight(int right) {
        if (right < 0) {
            throw new IllegalArgumentException("expected top >= 0");
        }
        Insets old = this.c.insets;
        this.c.insets = new Insets(old.top, old.left, old.bottom, right);
        return this;
    }

    public GridBagConstraintsBuilder anchorCenter() {
        this.c.anchor = 10;
        return this;
    }

    public GridBagConstraintsBuilder anchorNorth() {
        this.c.anchor = 11;
        return this;
    }

    public GridBagConstraintsBuilder anchorSouth() {
        this.c.anchor = 15;
        return this;
    }

    public GridBagConstraintsBuilder anchorEast() {
        this.c.anchor = 13;
        return this;
    }

    public GridBagConstraintsBuilder anchorWest() {
        this.c.anchor = 17;
        return this;
    }

    public GridBagConstraintsBuilder anchorNorthEast() {
        this.c.anchor = 12;
        return this;
    }

    public GridBagConstraintsBuilder anchorNorthWest() {
        this.c.anchor = 18;
        return this;
    }

    public GridBagConstraintsBuilder anchorSouthEast() {
        this.c.anchor = 14;
        return this;
    }

    public GridBagConstraintsBuilder anchorSouthWest() {
        this.c.anchor = 16;
        return this;
    }

    public GridBagConstraintsBuilder anchorPageStart() {
        this.c.anchor = 19;
        return this;
    }

    public GridBagConstraintsBuilder anchorPageEnd() {
        this.c.anchor = 20;
        return this;
    }

    public GridBagConstraintsBuilder anchorLineStart() {
        this.c.anchor = 21;
        return this;
    }

    public GridBagConstraintsBuilder anchorLineEnd() {
        this.c.anchor = 22;
        return this;
    }

    public GridBagConstraintsBuilder anchorFirstLineStart() {
        this.c.anchor = 23;
        return this;
    }

    public GridBagConstraintsBuilder anchorFirstLineEnd() {
        this.c.anchor = 24;
        return this;
    }

    public GridBagConstraintsBuilder anchorLastLineStart() {
        this.c.anchor = 25;
        return this;
    }

    public GridBagConstraintsBuilder anchorLastLineEnd() {
        this.c.anchor = 25;
        return this;
    }

    public GridBagConstraintsBuilder fillNone() {
        this.c.fill = 0;
        return this;
    }

    public GridBagConstraintsBuilder fillHorizontal() {
        this.c.fill = 2;
        return this;
    }

    public GridBagConstraintsBuilder fillVertical() {
        this.c.fill = 3;
        return this;
    }

    public GridBagConstraintsBuilder fillBoth() {
        this.c.fill = 1;
        return this;
    }

    private static void reset(GridBagConstraints c) {
        c.gridx = -1;
        c.gridy = -1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.ipadx = 0;
        c.ipady = 0;
    }

    private static void copy(GridBagConstraints from, GridBagConstraints to) {
        to.gridx = from.gridx;
        to.gridy = from.gridy;
        to.gridwidth = from.gridwidth;
        to.gridheight = from.gridheight;
        to.weightx = from.weightx;
        to.weighty = from.weighty;
        to.anchor = from.anchor;
        to.fill = from.fill;
        to.insets = from.insets;
        to.ipadx = from.ipadx;
        to.ipady = from.ipady;
    }
}

