/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.ui.action;

import au.id.jericho.lib.html.Source;
import net.psammead.mwapi.MediaWiki;
import net.psammead.mwapi.MediaWikiException;
import net.psammead.mwapi.connection.Connection;
import net.psammead.mwapi.net.IllegalFormException;
import net.psammead.mwapi.net.JerichoUtil;
import net.psammead.mwapi.ui.EditException;
import net.psammead.mwapi.ui.Page;
import net.psammead.mwapi.ui.StoreRecreateException;
import net.psammead.mwapi.ui.StoreSpamException;
import net.psammead.mwapi.ui.UnexpectedAnswerException;
import net.psammead.mwapi.ui.action.UiSimpleActionBase;
import net.psammead.mwapi.ui.action.parser.ParsedEditForm;
import net.psammead.mwapi.ui.action.response.ResponseData;
import net.psammead.mwapi.ui.action.response.ResponseHandler;

public class PageStoreAction
extends UiSimpleActionBase {
    private Page conflict = null;

    public PageStoreAction(MediaWiki mediaWiki, Connection connection, Page page, String summary, boolean minorEdit) {
        this(mediaWiki, connection, page, summary, minorEdit, false);
    }

    public Page getConflict() {
        return this.conflict;
    }

    protected PageStoreAction(final MediaWiki mediaWiki, final Connection connection, final Page page, final String summary, final boolean minorEdit, final boolean secondTry) {
        super(mediaWiki, connection);
        this.simpleMethod(POST);
        this.simpleTitle(page.location.title);
        this.simpleArg("action", "submit");
        this.simpleArg("wpTextbox1", page.body);
        this.simpleArg("wpEdittime", page.editTime);
        if (page.startTime != null) {
            this.simpleArg("wpStarttime", page.startTime);
        }
        if (page.editToken != null) {
            this.simpleArg("wpEditToken", page.editToken);
        }
        if (page.watchThis && connection.isLoggedIn()) {
            this.simpleArg("wpWatchthis", "1");
        }
        this.simpleArg("wpSummary", summary);
        this.simpleArg("wpSave", "yes");
        if (minorEdit) {
            this.simpleArg("wpMinoredit", "1");
        }
        this.responseMessageHandler(200, "spamprotectionmatch", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                throw new StoreSpamException("cannot store spam link");
            }
        });
        this.responseMessageHandler(200, "confirmrecreate", new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                throw new StoreRecreateException("will not recreate deleted page");
            }
        });
        this.responseHandler(200, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                ParsedEditForm parsed;
                try {
                    Source source = JerichoUtil.createSource(data.responseBody, PageStoreAction.this.logger);
                    parsed = new ParsedEditForm(PageStoreAction.this.urlManager, data.formURL, source);
                }
                catch (IllegalFormException e) {
                    throw new EditException("editform not usable, the page may be protected").addFactoid("location", page.location);
                }
                if (parsed.conflict) {
                    PageStoreAction.this.logger.info("store not successful, conflict detected");
                    PageStoreAction.this.conflict = parsed.page(false);
                    return true;
                }
                if (!secondTry) {
                    PageStoreAction.this.logger.info("store not successful, preview detected, retrying");
                    PageStoreAction retry = new PageStoreAction(mediaWiki, connection, parsed.page(false).edit(page.body), summary, minorEdit, true);
                    retry.execute();
                    PageStoreAction.this.conflict = retry.getConflict();
                    return true;
                }
                throw new UnexpectedAnswerException("store secondy try not successful").addFactoid("status", data.statusLine);
            }
        });
        this.responseHandler(302, new ResponseHandler(){

            public boolean handle(ResponseData data) throws MediaWikiException {
                if (data.responseBody.trim().length() != 0) {
                    PageStoreAction.this.logger.warn("weird, store returned: " + data.statusLine + "\n" + data.responseBody);
                }
                PageStoreAction.this.logger.info("store successful");
                PageStoreAction.this.conflict = null;
                return true;
            }
        });
    }
}

