/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.scrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.psammead.mwapi.scrapper.HttpResult;
import net.psammead.mwapi.scrapper.HttpUtil;
import net.psammead.util.IOUtil;
import net.psammead.util.Logger;
import net.psammead.util.Throttle;

public class HttpUtilJDK
implements HttpUtil {
    private static final Logger log = new Logger(HttpUtilJDK.class);
    private Throttle throttle = new Throttle(100L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResult download(URL url) throws IOException {
        try {
            this.throttle.gate();
        }
        catch (InterruptedException e) {
            throw new IOException("download aborted");
        }
        log.info("GET " + url);
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-agent", "scrapper/1.0");
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("GET");
            connection.setAllowUserInteraction(false);
            connection.connect();
            String type = connection.getContentType();
            if (type == null) {
                throw new RuntimeException("no contenttype in: " + url);
            }
            String charset = this.charset(type);
            String body = IOUtil.readStringFromStream((InputStream)connection.getInputStream(), (String)charset);
            HttpResult httpResult = new HttpResult(charset, body);
            return httpResult;
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    log.warn("closing connection failed", (Throwable)e);
                }
            }
        }
    }

    private String charset(String contentType) {
        int pos = contentType.indexOf("charset=");
        if (pos >= 0) {
            String charset = contentType.substring(pos + "charset=".length());
            int pos2 = charset.indexOf(";");
            if (pos2 >= 0) {
                charset = charset.substring(0, pos2);
            }
            return charset;
        }
        if ("text/xml".equals(contentType)) {
            return "utf-8";
        }
        return "iso-8859-1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String redirectsTo(URL url) throws IOException {
        try {
            this.throttle.gate();
        }
        catch (InterruptedException e) {
            throw new IOException("download aborted");
        }
        log.info("GET " + url);
        HttpURLConnection connection = null;
        try {
            String location;
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-agent", "scrapper/1.0");
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("GET");
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(false);
            int code = connection.getResponseCode();
            if (code != 302 && code != 301) {
                String string = null;
                return string;
            }
            String string = location = connection.getHeaderField("location");
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void useSystemProxy() throws MalformedURLException {
        String proxy = System.getenv("http_proxy");
        if (proxy == null) {
            return;
        }
        URL url = new URL(proxy);
        this.useProxy(url.getHost(), url.getPort());
    }

    public void useProxy(String host, int port) {
        System.setProperty("http.proxyHost", host);
        System.setProperty("http.proxyPort", "" + port);
    }
}

