/*
 * Decompiled with CFR 0.152.
 */
package net.psammead.mwapi.connection;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import net.psammead.mwapi.ui.UnsupportedURLException;

public final class TitleUtil {
    private TitleUtil() {
    }

    public static String buildWiki(String family, String language) {
        return family + (language != null ? ":" + language : "");
    }

    public static String underscores(String title) {
        return title.replace(' ', '_');
    }

    public static String spaces(String title) {
        return title.replace('_', ' ');
    }

    public static String encodeTitle(String title, String charSet) throws UnsupportedURLException {
        try {
            return URLEncoder.encode(title, charSet).replaceAll("%%", "\u0000").replaceAll("%3a", ":").replaceAll("%3A", ":").replaceAll("%2f", "/").replaceAll("%2F", "/").replaceAll("\u0000", "%%");
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedURLException("encoding problem", e);
        }
    }

    public static String decodeTitle(String title, String charSet) throws UnsupportedURLException {
        try {
            return URLDecoder.decode(title.replaceAll("\\+", "%2b"), charSet);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedURLException("encoding problem", e);
        }
    }
}

