/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.UnsupportedEncodingException;

public class SourceDebugExtensionWriter
extends ClassWriter.Element {
    private final int attrID;
    private byte[] table;

    public SourceDebugExtensionWriter(ClassWriter classWriter) {
        if (classWriter == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = classWriter.addCPUtf8("SourceDebugExtension");
    }

    public int getSize() {
        return this.table == null ? 6 : 6 + this.table.length;
    }

    public int copyInto(byte[] byArray, int n) throws IllegalArgumentException {
        ClassWriter.setUShort(byArray, n, this.attrID);
        ClassWriter.setInt(byArray, n + 2, this.getSize() - 6);
        n += 6;
        if (this.table != null) {
            int n2 = 0;
            while (n2 < this.table.length) {
                ClassWriter.setUByte(byArray, n, this.table[n2]);
                ++n;
                ++n2;
            }
        }
        return n;
    }

    public void setRawTable(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] < 1) {
                throw new IllegalArgumentException("Invalid CP index: " + byArray[n]);
            }
            ++n;
        }
        this.table = byArray;
    }

    public void setDebugInfo(String string) {
        if (string == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.setRawTable(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException);
        }
    }
}

