/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class LocalVariableTableReader
extends AttributeReader {
    public LocalVariableTableReader(ClassReader.AttrIterator attrIterator) throws InvalidClassFileException {
        super(attrIterator, "LocalVariableTable");
        int n = this.attr + 6;
        this.checkSize(n, 2);
        int n2 = this.cr.getUShort(n);
        this.checkSize(n += 2, n2 * 10);
    }

    public int[] getRawTable() {
        int n = this.cr.getUShort(this.attr + 6);
        int[] nArray = new int[n * 5];
        int n2 = this.attr + 8;
        int n3 = 0;
        while (n3 < nArray.length) {
            nArray[n3] = this.cr.getUShort(n2);
            n2 += 2;
            ++n3;
        }
        return nArray;
    }

    private static int[] makeVarVector(int[] nArray, int n, int n2, int n3) {
        int[] nArray2;
        if (nArray == null) {
            nArray2 = new int[(n + 1) * 2];
        } else {
            nArray2 = new int[Math.max(nArray.length, (n + 1) * 2)];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        }
        nArray2[n * 2] = n2;
        nArray2[n * 2 + 1] = n3;
        return nArray2;
    }

    public static int[][] makeVarMap(CodeReader codeReader) throws InvalidClassFileException, IllegalArgumentException {
        if (codeReader == null) {
            throw new IllegalArgumentException();
        }
        Object object = null;
        ClassReader classReader = codeReader.getClassReader();
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        codeReader.initAttributeIterator(attrIterator);
        while (attrIterator.isValid()) {
            if (attrIterator.getName().equals("LocalVariableTable")) {
                if (object == null) {
                    object = new int[codeReader.getBytecodeLength()][];
                }
                new LocalVariableTableReader(attrIterator);
                int n = attrIterator.getRawOffset();
                int n2 = classReader.getUShort(n + 6);
                int n3 = n + 8;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = classReader.getUShort(n3);
                    int n6 = classReader.getUShort(n3 + 2);
                    int n7 = classReader.getUShort(n3 + 4);
                    int n8 = classReader.getUShort(n3 + 6);
                    int n9 = classReader.getUShort(n3 + 8);
                    n3 += 10;
                    if (n9 < 0) {
                        throw new InvalidClassFileException(n3, "Invalid variable index " + n9 + " in LocalVariableTable");
                    }
                    if (n5 < 0) {
                        throw new InvalidClassFileException(n3, "Invalid startPC " + n5 + " in LocalVariableTable");
                    }
                    if (n5 + n6 > ((int[][])object).length) {
                        throw new InvalidClassFileException(n3, "Invalid startPC+length " + (n5 + n6) + " > " + ((int[][])object).length + " in LocalVariableTable");
                    }
                    int n10 = n5;
                    while (n10 < n5 + n6) {
                        int n11 = 1;
                        while (n10 + n11 < n5 + n6 && object[n10 + n11] == object[n10]) {
                            ++n11;
                        }
                        int[] nArray = LocalVariableTableReader.makeVarVector(object[n10], n9, n7, n8);
                        int n12 = n10;
                        while (n12 < n10 + n11) {
                            object[n12] = nArray;
                            ++n12;
                        }
                        n10 += n11;
                    }
                    ++n4;
                }
            }
            attrIterator.advance();
        }
        return object;
    }
}

