/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.AttributeReader;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;

public final class InnerClassesReader
extends AttributeReader {
    public InnerClassesReader(ClassReader.AttrIterator attrIterator) throws InvalidClassFileException {
        super(attrIterator, "InnerClasses");
        this.checkSize(this.attr, 8);
        int n = this.cr.getUShort(this.attr + 6);
        this.checkSizeEquals(this.attr + 8, 8 * n);
    }

    public int[] getRawTable() {
        int n = this.cr.getUShort(this.attr + 6);
        int[] nArray = new int[n * 4];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = this.cr.getUShort(this.attr + 8 + n2 * 2);
            ++n2;
        }
        return nArray;
    }

    public String[] getInnerClasses() throws InvalidClassFileException {
        int n = this.cr.getUShort(this.attr + 6);
        String[] stringArray = new String[n];
        ConstantPoolParser constantPoolParser = this.cr.getCP();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray[n2] = constantPoolParser.getCPClass(this.cr.getUShort(this.attr + 8 + n2 * 8));
            ++n2;
        }
        return stringArray;
    }

    public String getOuterClass(String string) throws InvalidClassFileException {
        String[] stringArray = this.getInnerClasses();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            if (stringArray[n].equals(string) && (n2 = this.cr.getUShort(this.attr + 8 + n * 8 + 2)) != 0) {
                ConstantPoolParser constantPoolParser = this.cr.getCP();
                return constantPoolParser.getCPClass(this.cr.getUShort(this.attr + 8 + n * 8 + 2));
            }
            ++n;
        }
        return null;
    }

    public int getAccessFlags(String string) throws InvalidClassFileException {
        String[] stringArray = this.getInnerClasses();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals(string)) {
                return this.cr.getUShort(this.attr + 8 + n * 8 + 6);
            }
            ++n;
        }
        return 0;
    }
}

