/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.MethodEditor;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintStream;
import java.io.Writer;

public class MethodTracer {
    private static final boolean disasm = true;
    private static final boolean verify = true;
    private static final boolean INSTRUMENT_CALLERS = false;
    private static OfflineInstrumenter instrumenter;
    static final Instruction getSysErr;
    static final Instruction callPrintln;

    static {
        getSysErr = Util.makeGet(System.class, "err");
        callPrintln = Util.makeInvoke(PrintStream.class, "println", new Class[]{String.class});
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        while (n < 1) {
            ClassInstrumenter classInstrumenter;
            instrumenter = new OfflineInstrumenter();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter("report", false));
            instrumenter.parseStandardArgs(stringArray);
            instrumenter.setPassUnmodifiedClasses(false);
            instrumenter.beginTraversal();
            while ((classInstrumenter = instrumenter.nextClass()) != null) {
                MethodTracer.doClass(classInstrumenter, bufferedWriter);
            }
            instrumenter.close();
            ++n;
        }
    }

    private static void doClass(ClassInstrumenter classInstrumenter, Writer writer) throws Exception {
        writer.write("Class: " + classInstrumenter.getReader().getName() + "\n");
        writer.flush();
        int n = 0;
        while (n < classInstrumenter.getReader().getMethodCount()) {
            MethodData methodData = classInstrumenter.visitMethod(n);
            if (methodData != null) {
                writer.write("Instrumenting " + classInstrumenter.getReader().getMethodName(n) + " " + classInstrumenter.getReader().getMethodType(n) + ":\n");
                writer.flush();
                writer.write("Initial ShrikeBT code:\n");
                new Disassembler(methodData).disassembleTo(writer);
                writer.flush();
                Object object = new Verifier(methodData);
                ((Verifier)object).verify();
                object = new MethodEditor(methodData);
                ((MethodEditor)object).beginPass();
                final String string = "Call to " + Util.makeClass("L" + classInstrumenter.getReader().getName() + ";") + "." + classInstrumenter.getReader().getMethodName(n);
                ((MethodEditor)object).insertAtStart(new MethodEditor.Patch(){

                    public void emitTo(MethodEditor.Output output) {
                        output.emit(getSysErr);
                        output.emit(ConstantInstruction.makeString(string));
                        output.emit(callPrintln);
                    }
                });
                ((MethodEditor)object).applyPatches();
                writer.write("Final ShrikeBT code:\n");
                new Disassembler(methodData).disassembleTo(writer);
                writer.flush();
                Verifier verifier = new Verifier(methodData);
                verifier.verify();
            }
            ++n;
        }
        if (classInstrumenter.isChanged()) {
            instrumenter.outputModifiedClass(classInstrumenter);
        }
    }
}

