/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.Disassembler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeBT.shrikeCT.CTUtils;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;

public class BatchVerifier {
    private static boolean disasm = false;
    private static final ClassHierarchyStore store = new ClassHierarchyStore();
    private static int errors = 0;

    public static void main(String[] stringArray) throws Exception {
        ClassInstrumenter classInstrumenter;
        OfflineInstrumenter offlineInstrumenter = new OfflineInstrumenter();
        stringArray = offlineInstrumenter.parseStandardArgs(stringArray);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-d")) {
                disasm = true;
            }
            ++n;
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter("report", false)));
        offlineInstrumenter.beginTraversal();
        while ((classInstrumenter = offlineInstrumenter.nextClass()) != null) {
            ClassReader classReader = classInstrumenter.getReader();
            CTUtils.addClassToHierarchy(store, classReader);
        }
        offlineInstrumenter.beginTraversal();
        while ((classInstrumenter = offlineInstrumenter.nextClass()) != null) {
            BatchVerifier.doClass(classInstrumenter.getReader(), printWriter);
        }
        offlineInstrumenter.close();
        if (errors > 0) {
            System.err.println(String.valueOf(errors) + " error" + (errors > 1 ? "s" : "") + " detected");
        }
    }

    private static void doClass(ClassReader classReader, PrintWriter printWriter) throws Exception {
        int n = classReader.getMethodCount();
        printWriter.write("Verifying " + classReader.getName() + "\n");
        printWriter.flush();
        ClassReader.AttrIterator attrIterator = new ClassReader.AttrIterator();
        int n2 = 0;
        while (n2 < n) {
            classReader.initMethodAttributeIterator(n2, attrIterator);
            while (attrIterator.isValid()) {
                if (attrIterator.getName().equals("Code")) {
                    printWriter.write("Verifying " + classReader.getName() + "." + classReader.getMethodName(n2) + " " + classReader.getMethodType(n2) + ":\n");
                    printWriter.flush();
                    CodeReader codeReader = new CodeReader(attrIterator);
                    CTDecoder cTDecoder = new CTDecoder(codeReader);
                    try {
                        cTDecoder.decode();
                    }
                    catch (Decoder.InvalidBytecodeException invalidBytecodeException) {
                        throw new InvalidClassFileException(codeReader.getRawOffset(), invalidBytecodeException.getMessage());
                    }
                    MethodData methodData = new MethodData(cTDecoder, classReader.getMethodAccessFlags(n2), CTDecoder.convertClassToType(classReader.getName()), classReader.getMethodName(n2), classReader.getMethodType(n2));
                    if (disasm) {
                        printWriter.write("ShrikeBT code:\n");
                        new Disassembler(methodData).disassembleTo(printWriter);
                        printWriter.flush();
                    }
                    Verifier verifier = new Verifier(methodData);
                    try {
                        verifier.verify();
                    }
                    catch (Analyzer.FailureException failureException) {
                        printWriter.println("ERROR: VERIFICATION FAILED");
                        failureException.printStackTrace(printWriter);
                        failureException.printPath(printWriter);
                        ++errors;
                        printWriter.flush();
                    }
                    break;
                }
                attrIterator.advance();
            }
            ++n2;
        }
    }
}

