/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.ConstantValueWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;

public class AddSerialVersion {
    private AddSerialVersion() {
    }

    public static void addSerialVersionUID(ClassReader classReader, ClassWriter classWriter) throws InvalidClassFileException {
        if (classReader == null) {
            throw new IllegalArgumentException("r is null");
        }
        int n = classReader.getFieldCount();
        int n2 = 0;
        while (n2 < n) {
            if (classReader.getFieldName(n2).equals("serialVersionUID")) {
                return;
            }
            ++n2;
        }
        long l = AddSerialVersion.computeSerialVersionUID(classReader);
        classWriter.addField(25, "serialVersionUID", "J", new ClassWriter.Element[]{new ConstantValueWriter(classWriter, l)});
    }

    public static long computeSerialVersionUID(ClassReader classReader) throws InvalidClassFileException {
        Object[] objectArray;
        MessageDigest messageDigest;
        if (classReader == null) {
            throw new IllegalArgumentException("r is null");
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("SHA algorithm not supported: " + noSuchAlgorithmException.getMessage());
        }
        SinkOutputStream sinkOutputStream = new SinkOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(sinkOutputStream, messageDigest));
        try {
            try {
                int n;
                dataOutputStream.writeUTF(classReader.getName());
                dataOutputStream.writeInt(classReader.getAccessFlags());
                objectArray = classReader.getInterfaceNames();
                Arrays.sort(objectArray);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    dataOutputStream.writeUTF((String)objectArray[n2]);
                    ++n2;
                }
                Integer[] integerArray = new Integer[classReader.getFieldCount()];
                final String[] stringArray = new String[integerArray.length];
                int n3 = 0;
                int n4 = 0;
                while (n4 < integerArray.length) {
                    n = classReader.getFieldAccessFlags(n4);
                    if ((n & 2) == 0 || (n & 0x88) == 0) {
                        integerArray[n3] = new Integer(n4);
                        stringArray[n4] = classReader.getFieldName(n4);
                        ++n3;
                    }
                    ++n4;
                }
                Arrays.sort(integerArray, 0, n3, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        String string = stringArray[n];
                        String string2 = stringArray[n2];
                        return string.compareTo(string2);
                    }
                });
                n4 = 0;
                while (n4 < n3) {
                    n = integerArray[n4];
                    dataOutputStream.writeUTF(stringArray[n]);
                    dataOutputStream.writeInt(classReader.getFieldAccessFlags(n));
                    dataOutputStream.writeUTF(classReader.getFieldType(n));
                    ++n4;
                }
                Integer[] integerArray2 = new Integer[classReader.getMethodCount()];
                final int[] nArray = new int[integerArray2.length];
                final String[] stringArray2 = new String[integerArray2.length];
                int n5 = 0;
                int n6 = 0;
                while (n6 < stringArray2.length) {
                    String string = classReader.getMethodName(n6);
                    int n7 = classReader.getMethodAccessFlags(n6);
                    if (string.equals("<clinit>") || (n7 & 2) == 0) {
                        integerArray2[n5] = new Integer(n6);
                        stringArray2[n6] = String.valueOf(string) + classReader.getMethodType(n6);
                        nArray[n6] = string.equals("<clinit>") ? 0 : (string.equals("<init>") ? 1 : 2);
                        ++n5;
                    }
                    ++n6;
                }
                Arrays.sort(integerArray2, 0, n5, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        int n3;
                        int n4 = n;
                        if (nArray[n4] != nArray[n3 = n2.intValue()]) {
                            return nArray[n4] - nArray[n3];
                        }
                        String string = stringArray2[n4];
                        String string2 = stringArray2[n3];
                        return string.compareTo(string2);
                    }
                });
                n6 = 0;
                while (n6 < n5) {
                    int n8 = integerArray2[n6];
                    dataOutputStream.writeUTF(classReader.getMethodName(n8));
                    dataOutputStream.writeInt(classReader.getMethodAccessFlags(n8));
                    dataOutputStream.writeUTF(classReader.getMethodType(n8));
                    ++n6;
                }
            }
            catch (IOException iOException) {
                throw new Error("Unexpected IOException: " + iOException.getMessage());
            }
        }
        catch (Throwable throwable) {
            try {
                dataOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {}
        objectArray = messageDigest.digest();
        return objectArray[0] & 0xFF | (objectArray[1] & 0xFF) << 8 | (objectArray[2] & 0xFF) << 16 | objectArray[3] << 24 | (objectArray[4] & 0xFF) << 32 | (objectArray[5] & 0xFF) << 40 | (objectArray[6] & 0xFF) << 48 | (objectArray[7] & 0xFF) << 56;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("args[" + n + "] is null");
            }
            try {
                byte[] byArray = Util.readFully(new FileInputStream(stringArray[n]));
                ClassReader classReader = new ClassReader(byArray);
                System.out.println(String.valueOf(Util.makeClass(classReader.getName())) + ": serialVersionUID = " + AddSerialVersion.computeSerialVersionUID(classReader));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found: " + stringArray[n]);
            }
            catch (IOException iOException) {
                System.err.println("Error reading file: " + stringArray[n]);
            }
            catch (InvalidClassFileException invalidClassFileException) {
                System.err.println("Invalid class file: " + stringArray[n]);
            }
            ++n;
        }
    }

    public static final class SinkOutputStream
    extends OutputStream {
        public void write(int n) {
        }

        public void write(byte[] byArray) {
        }

        public void write(byte[] byArray, int n, int n2) {
        }
    }
}

