/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableWriter;

public class CTUtils {
    public static void addClassToHierarchy(ClassHierarchyStore classHierarchyStore, ClassReader classReader) throws InvalidClassFileException, IllegalArgumentException {
        if (classHierarchyStore == null) {
            throw new IllegalArgumentException("store is null");
        }
        if (classReader == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = new String[classReader.getInterfaceCount()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = CTDecoder.convertClassToType(classReader.getInterfaceName(n));
            ++n;
        }
        String string = classReader.getSuperName();
        classHierarchyStore.setClassInfo(CTDecoder.convertClassToType(classReader.getName()), (classReader.getAccessFlags() & 0x200) != 0, (classReader.getAccessFlags() & 0x10) != 0, string != null ? CTDecoder.convertClassToType(string) : null, stringArray);
    }

    public static void compileAndAddMethodToClassWriter(MethodData methodData, ClassWriter classWriter, ClassWriter.Element element) {
        Object[] objectArray;
        if (classWriter == null) {
            throw new IllegalArgumentException("classWriter is null");
        }
        if (methodData == null) {
            throw new IllegalArgumentException("md is null");
        }
        CTCompiler cTCompiler = CTCompiler.make(classWriter, methodData);
        cTCompiler.compile();
        Compiler.Output output = cTCompiler.getOutput();
        CodeWriter codeWriter = new CodeWriter(classWriter);
        codeWriter.setMaxStack(output.getMaxStack());
        codeWriter.setMaxLocals(output.getMaxLocals());
        codeWriter.setCode(output.getCode());
        codeWriter.setRawHandlers(output.getRawHandlers());
        ClassWriter.Element element2 = null;
        if (element == null) {
            objectArray = new int[codeWriter.getCodeLength()];
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = n;
                ++n;
            }
            int[] nArray = LineNumberTableWriter.makeRawTable(objectArray);
            element2 = new LineNumberTableWriter(classWriter);
            ((LineNumberTableWriter)element2).setRawTable(nArray);
        }
        codeWriter.setAttributes(new ClassWriter.Element[]{element == null ? element2 : element});
        objectArray = new ClassWriter.Element[]{codeWriter};
        classWriter.addMethod(methodData.getAccess(), methodData.getName(), methodData.getSignature(), (ClassWriter.Element[])objectArray);
    }
}

