/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class StoreInstruction
extends Instruction
implements IStoreInstruction {
    private final int index;
    private static final StoreInstruction[] preallocated = StoreInstruction.preallocate();

    protected StoreInstruction(short s, int n) {
        super(s);
        this.index = n;
    }

    private static StoreInstruction[] preallocate() {
        StoreInstruction[] storeInstructionArray = new StoreInstruction[80];
        int n = 0;
        while (n < 5) {
            int n2 = 0;
            while (n2 < 4) {
                storeInstructionArray[n * 16 + n2] = new StoreInstruction((short)(59 + n2 + n * 4), n2);
                ++n2;
            }
            n2 = 4;
            while (n2 < 16) {
                storeInstructionArray[n * 16 + n2] = new StoreInstruction((short)(54 + n), n2);
                ++n2;
            }
            ++n;
        }
        return storeInstructionArray;
    }

    public static StoreInstruction make(String string, int n) throws IllegalArgumentException {
        int n2 = Util.getTypeIndex(string);
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Cannot store local of type " + string);
        }
        if (n < 16) {
            return preallocated[n2 * 16 + n];
        }
        return new StoreInstruction((short)(54 + n2), n);
    }

    public int getVarIndex() {
        return this.index;
    }

    public String getType() {
        if (this.opcode < 59) {
            return indexedTypes[this.opcode - 54];
        }
        return indexedTypes[(this.opcode - 59) / 4];
    }

    public boolean equals(Object object) {
        if (object instanceof StoreInstruction) {
            StoreInstruction storeInstruction = (StoreInstruction)object;
            return storeInstruction.index == this.index && storeInstruction.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + this.index * 148091891;
    }

    public int getPoppedCount() {
        return 1;
    }

    public String toString() {
        return "LocalStore(" + this.getType() + "," + this.index + ")";
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitLocalStore(this);
    }

    public boolean isPEI() {
        return false;
    }
}

