/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class ShiftInstruction
extends Instruction
implements IShiftInstruction {
    private static final ShiftInstruction[] preallocated = ShiftInstruction.preallocate();

    protected ShiftInstruction(short s) {
        super(s);
    }

    private static ShiftInstruction[] preallocate() {
        ShiftInstruction[] shiftInstructionArray = new ShiftInstruction[6];
        int n = 0;
        while (n < shiftInstructionArray.length) {
            shiftInstructionArray[n] = new ShiftInstruction((short)(n + 120));
            ++n;
        }
        return shiftInstructionArray;
    }

    public static ShiftInstruction make(String string, IShiftInstruction.Operator operator) throws IllegalArgumentException {
        if (operator == null) {
            throw new IllegalArgumentException("operator is null");
        }
        int n = Util.getTypeIndex(string);
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("Cannot apply shift to type " + string);
        }
        return preallocated[(operator.ordinal() - IShiftInstruction.Operator.SHL.ordinal()) * 2 + n];
    }

    public boolean equals(Object object) {
        if (object instanceof ShiftInstruction) {
            ShiftInstruction shiftInstruction = (ShiftInstruction)object;
            return shiftInstruction.opcode == this.opcode;
        }
        return false;
    }

    public IShiftInstruction.Operator getOperator() {
        return IShiftInstruction.Operator.values()[(this.opcode - 120) / 2];
    }

    public int hashCode() {
        return this.opcode;
    }

    public int getPoppedCount() {
        return 2;
    }

    public String getPushedType(String[] stringArray) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public String getType() {
        return indexedTypes[this.opcode - 120 & 1];
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitShift(this);
    }

    public String toString() {
        return "Shift(" + this.getType() + "," + this.getOperator() + ")";
    }

    public boolean isPEI() {
        return false;
    }

    public boolean isUnsigned() {
        return false;
    }
}

