/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;

public final class MethodData {
    private final HashMap<Object, Results> map = new HashMap();
    private final int access;
    private final String classType;
    private final String name;
    private final String signature;
    private IInstruction[] instructions;
    private ExceptionHandler[][] handlers;
    private int[] instructionsToBytecodes;
    private boolean hasChanged = false;

    public static MethodData makeWithDefaultHandlersAndInstToBytecodes(int n, String string, String string2, String string3, IInstruction[] iInstructionArray) {
        ExceptionHandler[][] exceptionHandlerArray = new ExceptionHandler[iInstructionArray.length][];
        Arrays.fill((Object[])exceptionHandlerArray, new ExceptionHandler[0]);
        int[] nArray = new int[iInstructionArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = n2;
            ++n2;
        }
        return new MethodData(n, string, string2, string3, iInstructionArray, exceptionHandlerArray, nArray);
    }

    public MethodData(int n, String string, String string2, String string3, IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray) {
        this.classType = string;
        this.access = n;
        this.name = string2;
        this.signature = string3;
        this.instructions = iInstructionArray;
        this.handlers = exceptionHandlerArray;
        this.instructionsToBytecodes = nArray;
        if (iInstructionArray == null) {
            throw new IllegalArgumentException("Instruction array cannot be null");
        }
        if (exceptionHandlerArray == null) {
            throw new IllegalArgumentException("Handler array cannot be null");
        }
        if (nArray == null) {
            throw new IllegalArgumentException("InstructionToBytecodes array cannot be null");
        }
        if (iInstructionArray.length != exceptionHandlerArray.length) {
            throw new IllegalArgumentException("Handlers array must be the same length as the instructions");
        }
        if (iInstructionArray.length != nArray.length) {
            throw new IllegalArgumentException("Bytecode map array must be the same length as the instructions");
        }
    }

    public MethodData(Decoder decoder, int n, String string, String string2, String string3) throws NullPointerException {
        this(n, string, string2, string3, decoder.getInstructions(), decoder.getHandlers(), decoder.getInstructionsToBytecodes());
    }

    public void setHasChanged() {
        this.hasChanged = true;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getName() {
        return this.name;
    }

    public int getAccess() {
        return this.access;
    }

    public String getClassType() {
        return this.classType;
    }

    public boolean getIsStatic() {
        return (this.access & 8) != 0;
    }

    public boolean getIsSynchronized() {
        return (this.access & 0x20) != 0;
    }

    public ExceptionHandler[][] getHandlers() {
        return this.handlers;
    }

    public IInstruction[] getInstructions() {
        return this.instructions;
    }

    public int[] getInstructionsToBytecodes() {
        return this.instructionsToBytecodes;
    }

    public Results getInfo(Object object) {
        return this.map.get(object);
    }

    public void putInfo(Object object, Results results) {
        this.map.put(object, results);
    }

    void update(IInstruction[] iInstructionArray, ExceptionHandler[][] exceptionHandlerArray, int[] nArray, int[] nArray2) {
        Iterator<Object> iterator = this.map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Results results = this.map.get(object);
            if (!results.notifyUpdate(this, iInstructionArray, exceptionHandlerArray, nArray)) continue;
            iterator.remove();
        }
        this.instructions = iInstructionArray;
        this.handlers = exceptionHandlerArray;
        this.instructionsToBytecodes = nArray2;
        this.hasChanged = true;
    }

    public boolean getHasChanged() {
        return this.hasChanged;
    }

    public String toString() {
        return String.valueOf(this.getClassType()) + "." + this.getName() + this.getSignature();
    }

    public static interface Results {
        public boolean notifyUpdate(MethodData var1, IInstruction[] var2, ExceptionHandler[][] var3, int[] var4);
    }
}

