/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public final class LoadInstruction
extends Instruction
implements ILoadInstruction {
    private final int index;
    private static final LoadInstruction[] preallocated = LoadInstruction.preallocate();

    protected LoadInstruction(short s, int n) {
        super(s);
        this.index = n;
    }

    private static LoadInstruction[] preallocate() {
        LoadInstruction[] loadInstructionArray = new LoadInstruction[80];
        int n = 0;
        while (n < 5) {
            int n2 = 0;
            while (n2 < 4) {
                loadInstructionArray[n * 16 + n2] = new LoadInstruction((short)(26 + n2 + n * 4), n2);
                ++n2;
            }
            n2 = 4;
            while (n2 < 16) {
                loadInstructionArray[n * 16 + n2] = new LoadInstruction((short)(21 + n), n2);
                ++n2;
            }
            ++n;
        }
        return loadInstructionArray;
    }

    public static LoadInstruction make(String string, int n) throws IllegalArgumentException {
        int n2 = Util.getTypeIndex(string);
        if (n2 < 0 || n2 > 4) {
            throw new IllegalArgumentException("Cannot load local of type " + string);
        }
        if (n < 16) {
            return preallocated[n2 * 16 + n];
        }
        return new LoadInstruction((short)(21 + n2), n);
    }

    public int getVarIndex() {
        return this.index;
    }

    public String getType() {
        if (this.opcode < 26) {
            return indexedTypes[this.opcode - 21];
        }
        return indexedTypes[(this.opcode - 26) / 4];
    }

    public String getPushedType(String[] stringArray) {
        return this.getType();
    }

    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitLocalLoad(this);
    }

    public boolean equals(Object object) {
        if (object instanceof LoadInstruction) {
            LoadInstruction loadInstruction = (LoadInstruction)object;
            return loadInstruction.index == this.index && loadInstruction.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + this.index * 19801901;
    }

    public String toString() {
        return "LocalLoad(" + this.getType() + "," + this.index + ")";
    }

    public boolean isPEI() {
        return false;
    }

    public boolean isAddressOf() {
        return false;
    }
}

