/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.Util;

public abstract class ConstantInstruction
extends Instruction {
    public ConstantInstruction(short s) {
        super(s);
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    int getCPIndex() {
        return 0;
    }

    public abstract Object getValue();

    public abstract String getType();

    public static ConstantInstruction make(String string, Object object) throws IllegalArgumentException {
        if (string == null && object != null) {
            throw new IllegalArgumentException("(type == null) and (constant != null)");
        }
        if (object == null) {
            return ConstNull.makeInternal();
        }
        if (string.equals("Ljava/lang/String;")) {
            return ConstantInstruction.makeString((String)object);
        }
        if (string.equals("Ljava/lang/Class;")) {
            return ConstantInstruction.makeClass((String)object);
        }
        try {
            switch (Util.getTypeIndex(string)) {
                case 0: {
                    return ConstantInstruction.make(((Number)object).intValue());
                }
                case 1: {
                    return ConstantInstruction.make(((Number)object).longValue());
                }
                case 2: {
                    return ConstantInstruction.make(((Number)object).floatValue());
                }
                case 3: {
                    return ConstantInstruction.make(((Number)object).doubleValue());
                }
            }
            throw new IllegalArgumentException("Invalid type for constant: " + string);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    public static ConstantInstruction make(int n) {
        return ConstInt.makeInternal(n);
    }

    public static ConstantInstruction make(long l) {
        return ConstLong.makeInternal(l);
    }

    public static ConstantInstruction make(float f) {
        return ConstFloat.makeInternal(f);
    }

    public static ConstantInstruction make(double d) {
        return ConstDouble.makeInternal(d);
    }

    public static ConstantInstruction makeString(String string) {
        return string == null ? ConstNull.makeInternal() : ConstString.makeInternal(string);
    }

    public static ConstantInstruction makeClass(String string) {
        return ConstClass.makeInternal(string);
    }

    static ConstantInstruction make(ConstantPoolReader constantPoolReader, int n) {
        switch (constantPoolReader.getConstantPoolItemType(n)) {
            case 3: {
                return new LazyInt(19, constantPoolReader, n);
            }
            case 5: {
                return new LazyLong(20, constantPoolReader, n);
            }
            case 4: {
                return new LazyFloat(19, constantPoolReader, n);
            }
            case 6: {
                return new LazyDouble(20, constantPoolReader, n);
            }
            case 8: {
                return new LazyString(19, constantPoolReader, n);
            }
            case 7: {
                return new LazyClass(19, constantPoolReader, n);
            }
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (object instanceof ConstantInstruction) {
            ConstantInstruction constantInstruction = (ConstantInstruction)object;
            if (!constantInstruction.getType().equals(this.getType())) {
                return false;
            }
            if (constantInstruction.getValue() == null) {
                return this.getValue() == null;
            }
            if (this.getValue() == null) {
                return false;
            }
            return constantInstruction.getValue().equals(this.getValue());
        }
        return false;
    }

    public final String getPushedType(String[] stringArray) {
        return this.getType();
    }

    public final byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    public final int hashCode() {
        int n = this.getValue() == null ? 0 : this.getValue().hashCode();
        return this.getType().hashCode() + 14411 * n;
    }

    public final void visit(IInstruction.Visitor visitor) throws NullPointerException {
        visitor.visitConstant(this);
    }

    private static String quote(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            StringBuffer stringBuffer = new StringBuffer("\"");
            int n = string.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string.charAt(n2);
                switch (c) {
                    case '\"': {
                        stringBuffer.append('\\');
                        stringBuffer.append(c);
                        break;
                    }
                    case '\n': {
                        stringBuffer.append("\\\n");
                        break;
                    }
                    case '\t': {
                        stringBuffer.append("\\\t");
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            stringBuffer.append("\"");
            return stringBuffer.toString();
        }
        if (object == null) {
            return "null";
        }
        return object.toString();
    }

    public final String toString() {
        return "Constant(" + this.getType() + "," + ConstantInstruction.quote(this.getValue()) + ")";
    }

    public boolean isPEI() {
        return false;
    }

    public static class ClassToken {
        private final String typeName;

        ClassToken(String string) {
            this.typeName = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.typeName == null ? 0 : this.typeName.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ClassToken classToken = (ClassToken)object;
            return !(this.typeName == null ? classToken.typeName != null : !this.typeName.equals(classToken.typeName));
        }

        public String getTypeName() {
            return this.typeName;
        }
    }

    static class ConstClass
    extends ConstantInstruction {
        protected String typeName;

        protected ConstClass(short s, String string) {
            super(s);
            this.typeName = string;
        }

        static ConstClass makeInternal(String string) {
            return new ConstClass(19, string);
        }

        public Object getValue() {
            return new ClassToken(this.typeName);
        }

        public final String getType() {
            return "Ljava/lang/Class;";
        }

        public boolean isPEI() {
            return true;
        }
    }

    static class ConstDouble
    extends ConstantInstruction {
        protected double value;
        private static final ConstDouble[] preallocated = ConstDouble.preallocate();

        protected ConstDouble(short s, double d) {
            super(s);
            this.value = d;
        }

        private static ConstDouble[] preallocate() {
            ConstDouble[] constDoubleArray = new ConstDouble[]{new ConstDouble(14, 0.0), new ConstDouble(15, 1.0)};
            return constDoubleArray;
        }

        static ConstDouble makeInternal(double d) {
            if (d == 0.0 || d == 1.0) {
                return preallocated[(int)d];
            }
            return new ConstDouble(20, d);
        }

        public final Object getValue() {
            return new Double(this.getDoubleValue());
        }

        public final String getType() {
            return "D";
        }

        public double getDoubleValue() {
            return this.value;
        }
    }

    static class ConstFloat
    extends ConstantInstruction {
        protected float value;
        private static final ConstFloat[] preallocated = ConstFloat.preallocate();

        protected ConstFloat(short s, float f) {
            super(s);
            this.value = f;
        }

        private static ConstFloat[] preallocate() {
            ConstFloat[] constFloatArray = new ConstFloat[]{new ConstFloat(11, 0.0f), new ConstFloat(12, 1.0f), new ConstFloat(13, 2.0f)};
            return constFloatArray;
        }

        static ConstFloat makeInternal(float f) {
            if ((double)f == 0.0 || (double)f == 1.0 || (double)f == 2.0) {
                return preallocated[(int)f];
            }
            return new ConstFloat(19, f);
        }

        public final Object getValue() {
            return new Float(this.getFloatValue());
        }

        public final String getType() {
            return "F";
        }

        public float getFloatValue() {
            return this.value;
        }
    }

    static class ConstInt
    extends ConstantInstruction {
        protected int value;
        private static final ConstInt[] preallocated = ConstInt.preallocate();

        protected ConstInt(short s, int n) {
            super(s);
            this.value = n;
        }

        private static ConstInt[] preallocate() {
            ConstInt[] constIntArray = new ConstInt[256];
            int n = 0;
            while (n < constIntArray.length) {
                constIntArray[n] = new ConstInt(16, n - 128);
                ++n;
            }
            n = -1;
            while (n <= 5) {
                constIntArray[n + 128] = new ConstInt((short)(n - -1 + 2), n);
                ++n;
            }
            return constIntArray;
        }

        static ConstInt makeInternal(int n) {
            if ((byte)n == n) {
                return preallocated[n + 128];
            }
            if ((short)n == n) {
                return new ConstInt(17, n);
            }
            return new ConstInt(19, n);
        }

        public final Object getValue() {
            return this.getIntValue();
        }

        public final String getType() {
            return "I";
        }

        public int getIntValue() {
            return this.value;
        }
    }

    static class ConstLong
    extends ConstantInstruction {
        protected long value;
        private static final ConstLong[] preallocated = ConstLong.preallocate();

        protected ConstLong(short s, long l) {
            super(s);
            this.value = l;
        }

        private static ConstLong[] preallocate() {
            ConstLong[] constLongArray = new ConstLong[]{new ConstLong(9, 0L), new ConstLong(10, 1L)};
            return constLongArray;
        }

        static ConstLong makeInternal(long l) {
            if (l == 0L || l == 1L) {
                return preallocated[(int)l];
            }
            return new ConstLong(20, l);
        }

        public final Object getValue() {
            return this.getLongValue();
        }

        public final String getType() {
            return "J";
        }

        public long getLongValue() {
            return this.value;
        }
    }

    static final class ConstNull
    extends ConstantInstruction {
        private static final ConstNull preallocated = new ConstNull();

        protected ConstNull() {
            super((short)1);
        }

        static ConstNull makeInternal() {
            return preallocated;
        }

        public Object getValue() {
            return null;
        }

        public String getType() {
            return "L;";
        }
    }

    static class ConstString
    extends ConstantInstruction {
        protected String value;

        protected ConstString(short s, String string) {
            super(s);
            this.value = string;
        }

        static ConstString makeInternal(String string) {
            return new ConstString(19, string);
        }

        public Object getValue() {
            return this.value;
        }

        public final String getType() {
            return "Ljava/lang/String;";
        }
    }

    static final class LazyClass
    extends ConstClass {
        private final ConstantPoolReader cp;
        private final int index;

        protected LazyClass(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, null);
            this.cp = constantPoolReader;
            this.index = n;
        }

        public Object getValue() {
            if (this.typeName == null) {
                this.typeName = this.cp.getConstantPoolClassType(this.index);
            }
            return new ClassToken(this.typeName);
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static final class LazyDouble
    extends ConstDouble {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyDouble(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, 0.0);
            this.cp = constantPoolReader;
            this.index = n;
            this.isSet = false;
        }

        public double getDoubleValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolDouble(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static final class LazyFloat
    extends ConstFloat {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyFloat(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, 0.0f);
            this.cp = constantPoolReader;
            this.index = n;
            this.isSet = false;
        }

        public float getFloatValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolFloat(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static final class LazyInt
    extends ConstInt {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyInt(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, 0);
            this.cp = constantPoolReader;
            this.index = n;
            this.isSet = false;
        }

        public int getIntValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolInteger(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static final class LazyLong
    extends ConstLong {
        private final ConstantPoolReader cp;
        private final int index;
        private boolean isSet;

        protected LazyLong(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, 0L);
            this.cp = constantPoolReader;
            this.index = n;
            this.isSet = false;
        }

        public long getLongValue() {
            if (!this.isSet) {
                this.value = this.cp.getConstantPoolLong(this.index);
                this.isSet = true;
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }

    static final class LazyString
    extends ConstString {
        private final ConstantPoolReader cp;
        private final int index;

        protected LazyString(short s, ConstantPoolReader constantPoolReader, int n) {
            super(s, null);
            this.cp = constantPoolReader;
            this.index = n;
        }

        public Object getValue() {
            if (this.value == null) {
                this.value = this.cp.getConstantPoolString(this.index);
            }
            return this.value;
        }

        public ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        public int getCPIndex() {
            return this.index;
        }
    }
}

