/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrikeCT.ClassReader;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;

public class InterfaceAnalyzer {
    static final HashMap<String, TypeStats> typeStats = new HashMap();
    static int methodUID = 0;

    public static void main(String[] stringArray) throws Exception {
        ClassInstrumenter classInstrumenter;
        OfflineInstrumenter offlineInstrumenter = new OfflineInstrumenter();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
        stringArray = offlineInstrumenter.parseStandardArgs(stringArray);
        offlineInstrumenter.beginTraversal();
        while ((classInstrumenter = offlineInstrumenter.nextClass()) != null) {
            InterfaceAnalyzer.doClass(classInstrumenter.getReader());
        }
        offlineInstrumenter.close();
        bufferedWriter.write("Type\t# Total\t# Method\t# Public Method\t# Public Method as Foreign\n");
        for (String string : typeStats.keySet()) {
            TypeStats typeStats = InterfaceAnalyzer.typeStats.get(string);
            bufferedWriter.write(String.valueOf(string) + "\t" + typeStats.totalOccurrences + "\t" + typeStats.methodOccurrences + "\t" + typeStats.publicMethodOccurrences + "\t" + typeStats.foreignPublicMethodOccurrences + "\n");
        }
        ((Writer)bufferedWriter).close();
    }

    private static void doClass(ClassReader classReader) throws Exception {
        if ((classReader.getAccessFlags() & 0x200) != 0 && (classReader.getAccessFlags() & 1) != 0) {
            String string = Util.makeType(classReader.getName());
            int n = 0;
            while (n < classReader.getMethodCount()) {
                int n2;
                String string2 = classReader.getMethodType(n);
                String[] stringArray = Util.getParamsTypes(null, string2);
                int n3 = classReader.getMethodAccessFlags(n);
                ++methodUID;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    InterfaceAnalyzer.doType(n3, stringArray[n4], string, n2);
                    ++n4;
                }
                InterfaceAnalyzer.doType(n3, Util.getReturnType(string2), string, n2);
                ++n;
            }
        }
    }

    private static void doType(int n, String string, String string2, int n2) {
        TypeStats typeStats = InterfaceAnalyzer.typeStats.get(string);
        if (typeStats == null) {
            typeStats = new TypeStats();
            InterfaceAnalyzer.typeStats.put(string, typeStats);
        }
        ++typeStats.totalOccurrences;
        if (typeStats.lastMUID != n2) {
            ++typeStats.methodOccurrences;
            if ((n & 1) != 0) {
                ++typeStats.publicMethodOccurrences;
                String string3 = string;
                while (Util.isArrayType(string3)) {
                    string3 = string3.substring(1);
                }
                if (!Util.isPrimitiveType(string3) && !InterfaceAnalyzer.packagePart(string3, 2).equals(InterfaceAnalyzer.packagePart(string2, 2))) {
                    ++typeStats.foreignPublicMethodOccurrences;
                }
            }
        }
        typeStats.lastMUID = n2;
    }

    private static String packagePart(String string, int n) {
        String string2 = Util.makeClass(string);
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            int n4 = string2.indexOf(46, n2 + 1);
            if (n4 < 0) {
                return string2;
            }
            n2 = n4;
            ++n3;
        }
        return string2.substring(0, n2);
    }

    static final class TypeStats {
        int totalOccurrences;
        int methodOccurrences;
        int publicMethodOccurrences;
        int foreignPublicMethodOccurrences;
        int lastMUID;

        TypeStats() {
        }
    }
}

