/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SourceViewer
extends JPanel {
    private URL sourceURL = null;
    private JTextField sourceCodeLocation;
    private DefaultListModel sourceCodeLinesList = new DefaultListModel();
    private JList sourceCodeLines = new JList(this.sourceCodeLinesList);

    public SourceViewer() {
        super(new BorderLayout());
        this.sourceCodeLocation = new JTextField("Source code");
        this.add((Component)this.sourceCodeLocation, "First");
        this.add((Component)new JScrollPane(this.sourceCodeLines), "Center");
    }

    public void setSource(URL uRL) {
        this.setSource(uRL, -1);
    }

    public void setSource(URL uRL, int n) {
        boolean bl = this.loadSource(uRL);
        if (bl) {
            this.sourceCodeLocation.setText("Source code: " + uRL);
            if (n != -1) {
                this.sourceCodeLines.ensureIndexIsVisible(n - 1);
                this.sourceCodeLines.setSelectedIndex(n - 1);
                this.sourceCodeLines.validate();
            }
        } else {
            this.sourceCodeLocation.setText("Error loading source code from: " + uRL);
        }
    }

    private boolean loadSource(URL uRL) {
        if (uRL == null) {
            if (this.sourceURL != null) {
                this.sourceCodeLinesList.clear();
            }
            return false;
        }
        if (uRL.equals(this.sourceURL)) {
            return true;
        }
        this.sourceCodeLinesList.clear();
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            while ((string = bufferedReader.readLine()) != null) {
                this.sourceCodeLinesList.addElement(string.replaceAll("\t", "   "));
            }
            bufferedReader.close();
            return true;
        }
        catch (IOException iOException) {
            System.err.println("Could not load source at " + uRL);
            return false;
        }
    }

    public void removeSelection() {
        int n = this.sourceCodeLines.getSelectedIndex();
        this.sourceCodeLines.removeSelectionInterval(n, n);
    }

    public void removeSource() {
        this.sourceURL = null;
        this.sourceCodeLocation.setText("Source code");
        this.sourceCodeLinesList.clear();
        this.sourceCodeLines.validate();
    }
}

