/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz.viewer;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ChaPanel
extends JSplitPane {
    private final IClassHierarchy cha;

    public ChaPanel(IClassHierarchy iClassHierarchy) {
        this.cha = iClassHierarchy;
        this.setDividerLocation(250);
        JTree jTree = this.buildTree();
        this.setLeftComponent(new JScrollPane(jTree));
        final DefaultListModel defaultListModel = new DefaultListModel();
        JList jList = new JList(defaultListModel);
        this.setRightComponent(jList);
        jTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                IClass iClass = (IClass)defaultMutableTreeNode.getUserObject();
                defaultListModel.clear();
                for (IMethod iMethod : iClass.getDeclaredMethods()) {
                    defaultListModel.addElement(iMethod.toString());
                }
            }
        });
    }

    private JTree buildTree() {
        IClass iClass = this.cha.getRootClass();
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iClass);
        this.expandNode(defaultMutableTreeNode);
        JTree jTree = new JTree(defaultMutableTreeNode);
        jTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                TreePath treePath = treeExpansionEvent.getPath();
                if (treePath == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                ChaPanel.this.expandNode(defaultMutableTreeNode);
            }

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }
        });
        return jTree;
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.expandNode(defaultMutableTreeNode, 3);
    }

    private void expandNode(DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        Object object;
        if (n == 0) {
            return;
        }
        if (defaultMutableTreeNode.getChildCount() == 0) {
            IClass iClass = (IClass)defaultMutableTreeNode.getUserObject();
            object = this.cha.getImmediateSubclasses(iClass);
            Iterator<IClass> iterator = object.iterator();
            while (iterator.hasNext()) {
                IClass iClass2 = iterator.next();
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(iClass2));
            }
        }
        int n2 = 0;
        while (n2 < defaultMutableTreeNode.getChildCount()) {
            object = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(n2);
            this.expandNode((DefaultMutableTreeNode)object, n - 1);
            ++n2;
        }
    }
}

