/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.viz;

import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.warnings.WalaException;
import com.ibm.wala.viz.NodeDecorator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotUtil {
    private static DotOutputType outputType = DotOutputType.PDF;
    private static int fontSize = 6;
    private static String fontColor = "black";
    private static String fontName = "Arial";
    private static final int MAX_LABEL_LENGTH = Integer.MAX_VALUE;

    public static void setOutputType(DotOutputType dotOutputType) {
        outputType = dotOutputType;
    }

    public static DotOutputType getOutputType() {
        return outputType;
    }

    private static String outputTypeCmdLineParam() {
        switch (outputType) {
            case PS: {
                return "-Tps";
            }
            case EPS: {
                return "-Teps";
            }
            case SVG: {
                return "-Tsvg";
            }
            case PDF: {
                return "-Tpdf";
            }
        }
        Assertions.UNREACHABLE();
        return null;
    }

    public static <T> void dotify(Graph<T> graph, NodeDecorator nodeDecorator, String string, String string2, String string3) throws WalaException {
        DotUtil.dotify(graph, nodeDecorator, null, string, string2, string3);
    }

    public static <T> void dotify(Graph<T> graph, NodeDecorator nodeDecorator, String string, String string2, String string3, String string4) throws WalaException {
        if (graph == null) {
            throw new IllegalArgumentException("g is null");
        }
        File file = DotUtil.writeDotFile(graph, nodeDecorator, string, string2);
        DotUtil.spawnDot(string4, string3, file);
    }

    public static void spawnDot(String string, String string2, File file) throws WalaException {
        if (file == null) {
            throw new IllegalArgumentException("dotFile is null");
        }
        Object[] objectArray = new String[]{string, DotUtil.outputTypeCmdLineParam(), "-o", string2, "-v", file.getAbsolutePath()};
        System.out.println("spawning process " + Arrays.toString(objectArray));
        BufferedInputStream bufferedInputStream = null;
        BufferedInputStream bufferedInputStream2 = null;
        try {
            try {
                Process process = Runtime.getRuntime().exec((String[])objectArray);
                bufferedInputStream = new BufferedInputStream(process.getInputStream());
                bufferedInputStream2 = new BufferedInputStream(process.getErrorStream());
                boolean bl = true;
                while (bl) {
                    int n;
                    byte[] byArray;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    if (bufferedInputStream.available() > 0) {
                        byArray = new byte[bufferedInputStream.available()];
                        n = bufferedInputStream.read(byArray);
                        System.err.println("read " + n + " bytes from output stream");
                    }
                    if (bufferedInputStream2.available() > 0) {
                        byArray = new byte[bufferedInputStream2.available()];
                        n = bufferedInputStream2.read(byArray);
                        System.err.println("read " + n + " bytes from error stream");
                    }
                    try {
                        process.exitValue();
                        bl = false;
                        System.out.println("process terminated with exit code " + process.exitValue());
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        bl = true;
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new WalaException("IOException in " + DotUtil.class);
            }
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (bufferedInputStream2 != null) {
                try {
                    bufferedInputStream2.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    public static <T> File writeDotFile(Graph<T> graph, NodeDecorator nodeDecorator, String string, String string2) throws WalaException {
        if (graph == null) {
            throw new IllegalArgumentException("g is null");
        }
        StringBuffer stringBuffer = DotUtil.dotOutput(graph, nodeDecorator, string);
        if (string2 == null) {
            throw new WalaException("internal error: null filename parameter");
        }
        try {
            File file = new File(string2);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
            return file;
        }
        catch (Exception exception) {
            throw new WalaException("Error writing dot file " + string2);
        }
    }

    private static <T> StringBuffer dotOutput(Graph<T> graph, NodeDecorator nodeDecorator, String string) throws WalaException {
        StringBuffer stringBuffer = new StringBuffer("digraph \"DirectedGraph\" {\n");
        if (string != null) {
            stringBuffer.append("graph [label = \"" + string + "\", labelloc=t, concentrate = true];");
        } else {
            stringBuffer.append("graph [concentrate = true];");
        }
        String string2 = DotUtil.getRankDir();
        if (string2 != null) {
            stringBuffer.append("rankdir=" + string2 + ";");
        }
        String string3 = "fontsize=" + fontSize;
        String string4 = fontColor != null ? ",fontcolor=" + fontColor : "";
        String string5 = fontName != null ? ",fontname=" + fontName : "";
        stringBuffer.append("center=true;");
        stringBuffer.append(string3);
        stringBuffer.append(";node [ color=blue,shape=\"box\"");
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        stringBuffer.append("];edge [ color=black,");
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        stringBuffer.append(string5);
        stringBuffer.append("]; \n");
        Collection<T> collection = DotUtil.computeDotNodes(graph);
        DotUtil.outputNodes(nodeDecorator, stringBuffer, collection);
        for (Object t : graph) {
            Iterator iterator = graph.getSuccNodes(t);
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                stringBuffer.append(" ");
                stringBuffer.append(DotUtil.getPort(t, nodeDecorator));
                stringBuffer.append(" -> ");
                stringBuffer.append(DotUtil.getPort(t2, nodeDecorator));
                stringBuffer.append(" \n");
            }
        }
        stringBuffer.append("\n}");
        return stringBuffer;
    }

    private static void outputNodes(NodeDecorator nodeDecorator, StringBuffer stringBuffer, Collection collection) throws WalaException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            DotUtil.outputNode(nodeDecorator, stringBuffer, iterator.next());
        }
    }

    private static void outputNode(NodeDecorator nodeDecorator, StringBuffer stringBuffer, Object object) throws WalaException {
        stringBuffer.append("   ");
        stringBuffer.append("\"");
        stringBuffer.append(DotUtil.getLabel(object, nodeDecorator));
        stringBuffer.append("\"");
        stringBuffer.append(DotUtil.decorateNode(object, nodeDecorator));
    }

    private static <T> Collection<T> computeDotNodes(Graph<T> graph) throws WalaException {
        return Iterator2Collection.toSet(graph.iterator());
    }

    private static String getRankDir() throws WalaException {
        return null;
    }

    private static String decorateNode(Object object, NodeDecorator nodeDecorator) throws WalaException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" [ ]\n");
        return stringBuffer.toString();
    }

    private static String getLabel(Object object, NodeDecorator nodeDecorator) throws WalaException {
        String string = null;
        if (nodeDecorator == null) {
            string = object.toString();
        } else {
            string = nodeDecorator.getLabel(object);
            String string2 = string = string == null ? object.toString() : string;
        }
        if (string.length() >= Integer.MAX_VALUE) {
            string = String.valueOf(string.substring(0, 0x7FFFFFFC)) + "...";
        }
        return string;
    }

    private static String getPort(Object object, NodeDecorator nodeDecorator) throws WalaException {
        return "\"" + DotUtil.getLabel(object, nodeDecorator) + "\"";
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static void setFontSize(int n) {
        fontSize = n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DotOutputType {
        PS,
        SVG,
        PDF,
        EPS;

    }
}

