/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table<T> {
    protected final ArrayList<SimpleVector<T>> rows = new ArrayList();
    protected final SimpleVector<String> columnHeadings = new SimpleVector();

    public Table() {
    }

    public Table(Table<T> table) throws IllegalArgumentException {
        if (table == null) {
            throw new IllegalArgumentException("t == null");
        }
        int n = 0;
        while (n < table.getNumberOfColumns()) {
            this.columnHeadings.set(n, table.getColumnHeading(n));
            ++n;
        }
    }

    public Table(String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null) {
            throw new IllegalArgumentException("columns == null");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null) {
                throw new IllegalArgumentException("columns[" + n + "] is null");
            }
            this.columnHeadings.set(n, stringArray[n]);
            ++n;
        }
    }

    public String toString() {
        int[] nArray = this.computeColumnWidths();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.getNumberOfColumns()) {
            StringBuffer stringBuffer2 = new StringBuffer(this.getColumnHeading(n));
            StringStuff.padWithSpaces(stringBuffer2, nArray[n]);
            stringBuffer.append(stringBuffer2);
            ++n;
        }
        stringBuffer.append("\n");
        n = 0;
        while (n < this.getNumberOfRows()) {
            int n2 = 0;
            while (n2 < this.getNumberOfColumns()) {
                T t = this.getElement(n, n2);
                StringBuffer stringBuffer3 = t == null ? new StringBuffer() : new StringBuffer(t.toString());
                StringStuff.padWithSpaces(stringBuffer3, nArray[n2]);
                stringBuffer.append(stringBuffer3);
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public synchronized T getElement(int n, int n2) {
        try {
            SimpleVector<T> simpleVector = this.rows.get(n);
            return simpleVector.get(n2);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("row: " + n + " column: " + n2);
        }
    }

    public synchronized String getColumnHeading(int n) {
        return this.columnHeadings.get(n);
    }

    public int[] computeColumnWidths() {
        int[] nArray = new int[this.getNumberOfColumns()];
        int n = 0;
        while (n < this.getNumberOfColumns()) {
            nArray[n] = this.columnHeadings.get(n).length() + 1;
            ++n;
        }
        n = 0;
        while (n < this.getNumberOfRows()) {
            int n2 = 0;
            while (n2 < this.getNumberOfColumns()) {
                T t = this.getElement(n, n2);
                nArray[n2] = t == null ? nArray[n2] : Math.max(nArray[n2], t.toString().length() + 1);
                ++n2;
            }
            ++n;
        }
        return nArray;
    }

    public synchronized int getNumberOfColumns() {
        return this.columnHeadings.getMaxIndex() + 1;
    }

    public synchronized int getNumberOfRows() {
        return this.rows.size();
    }

    public synchronized Map<String, T> row2Map(int n) {
        HashMap<String, T> hashMap = HashMapFactory.make();
        int n2 = 0;
        while (n2 < this.getNumberOfColumns()) {
            hashMap.put(this.getColumnHeading(n2), this.getElement(n, n2));
            ++n2;
        }
        return hashMap;
    }

    public synchronized void addRow(Map<String, T> map) {
        if (map == null) {
            throw new IllegalArgumentException("null p " + map);
        }
        SimpleVector<T> simpleVector = new SimpleVector<T>();
        this.rows.add(simpleVector);
        int n = 0;
        while (n < this.getNumberOfColumns()) {
            simpleVector.set(n, map.get(this.getColumnHeading(n)));
            ++n;
        }
    }

    public synchronized void removeRow(Map<String, T> map) {
        if (map == null) {
            throw new IllegalArgumentException("p is null");
        }
        BitVector bitVector = new BitVector();
        int n = 0;
        while (n < this.rows.size()) {
            Map<String, T> map2 = this.row2Map(n);
            if (map2.equals(map)) {
                bitVector.set(n);
            }
            ++n;
        }
        n = 0;
        while (n < this.rows.size()) {
            if (bitVector.get(n)) {
                this.rows.remove(n);
            }
            ++n;
        }
    }
}

