/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.tables;

import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.io.FileProvider;
import com.ibm.wala.util.tables.Table;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTable
extends Table<String>
implements Cloneable {
    public StringTable() {
    }

    public StringTable(StringTable stringTable) {
        super(stringTable);
    }

    public StringTable(String[] stringArray) {
        super(stringArray);
    }

    public static StringTable readFromDirectTextFile(String string, Character c) throws FileNotFoundException, IOException {
        if (string == null) {
            throw new IllegalArgumentException("fileName is null");
        }
        File file = new File(string);
        return StringTable.readFromTextFile(file, c);
    }

    public static StringTable readFromTextFile(String string, Character c) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
        File file = FileProvider.getFile(string);
        return StringTable.readFromTextFile(file, c);
    }

    public static StringTable readFromTextFile(File file, Character c) throws FileNotFoundException, IOException {
        if (file == null) {
            throw new IllegalArgumentException("null f");
        }
        return StringTable.readFromStream(new FileInputStream(file), c);
    }

    public static StringTable readFromStream(InputStream inputStream, Character c) throws IOException {
        return StringTable.readFromStream(inputStream, c, null);
    }

    public static StringTable readFromStream(InputStream inputStream, Character c, Character c2) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("s is null");
        }
        StringTable stringTable = new StringTable();
        LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
        String string = StringTable.readNextNonCommentLine(lineNumberReader, c);
        if (string == null) {
            throw new IOException("first line expected to be column headings");
        }
        stringTable.populateColumnHeadings(string, c2);
        string = StringTable.readNextNonCommentLine(lineNumberReader, c);
        int n = 0;
        while (string != null) {
            stringTable.populateRow(n, string, c2);
            string = StringTable.readNextNonCommentLine(lineNumberReader, c);
            ++n;
        }
        return stringTable;
    }

    public static String readNextNonCommentLine(LineNumberReader lineNumberReader, Character c) throws IOException {
        if (lineNumberReader == null) {
            throw new IllegalArgumentException("reader is null");
        }
        String string = lineNumberReader.readLine();
        while (string != null && StringTable.isCommented(string, c)) {
            string = lineNumberReader.readLine();
        }
        return string;
    }

    private static boolean isCommented(String string, Character c) {
        if (string.length() == 0) {
            return true;
        }
        if (c == null) {
            return false;
        }
        return string.charAt(0) == c.charValue();
    }

    private void populateRow(int n, String string, Character c) {
        StringTokenizer stringTokenizer = c == null ? new StringTokenizer(string) : new StringTokenizer(string, c.toString());
        int n2 = stringTokenizer.countTokens();
        Assertions.productionAssertion(n2 == this.getNumberOfColumns(), "expected " + this.getNumberOfColumns() + " got " + n2 + " row " + n + " " + string.length() + " " + string);
        SimpleVector<String> simpleVector = new SimpleVector<String>();
        this.rows.add(n, simpleVector);
        int n3 = 0;
        while (n3 < n2) {
            simpleVector.set(n3, (String)stringTokenizer.nextElement());
            ++n3;
        }
    }

    private void populateColumnHeadings(String string, Character c) {
        StringTokenizer stringTokenizer = c == null ? new StringTokenizer(string) : new StringTokenizer(string, c.toString());
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            this.columnHeadings.set(n2, (String)stringTokenizer.nextElement());
            ++n2;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        StringTable stringTable = new StringTable(this);
        int n = 0;
        while (n < this.getNumberOfRows()) {
            stringTable.addRow(this.row2Map(n));
            ++n;
        }
        return stringTable;
    }
}

