/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.util.strings.UTF8Convert;

public final class ImmutableByteArray {
    final byte[] b;

    public ImmutableByteArray(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        this.b = byArray;
    }

    public ImmutableByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (n < 0) {
            throw new IllegalArgumentException("invalid start: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("null length");
        }
        this.b = new byte[n2];
        try {
            System.arraycopy(byArray, n, this.b, 0, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("illegal parameters " + byArray.length + " " + n + " " + n2);
        }
    }

    public int length() {
        return this.b.length;
    }

    public byte get(int n) throws IllegalArgumentException {
        if (n < 0 || n >= this.b.length) {
            throw new IllegalArgumentException("index out of bounds " + this.b.length + " " + n);
        }
        return this.b[n];
    }

    public byte[] substring(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("illegal length: " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("illegal i: " + n);
        }
        byte[] byArray = new byte[n2];
        try {
            System.arraycopy(this.b, n, byArray, 0, n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid combination: " + n + " " + n2);
        }
        return byArray;
    }

    public static ImmutableByteArray concat(byte by, ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b1 is null");
        }
        byte[] byArray = new byte[immutableByteArray.length() + 1];
        byArray[0] = by;
        System.arraycopy(immutableByteArray.b, 0, byArray, 1, immutableByteArray.b.length);
        return new ImmutableByteArray(byArray);
    }

    public String toString() {
        return new String(this.b);
    }

    public static ImmutableByteArray make(String string) {
        return new ImmutableByteArray(UTF8Convert.toUTF8(string));
    }
}

