/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.strings;

import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.strings.ImmutableByteArray;
import com.ibm.wala.util.strings.UTF8Convert;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.util.HashMap;

public final class Atom
implements Serializable {
    private static final long serialVersionUID = -3256390509887654329L;
    private static final HashMap<AtomKey, Atom> dictionary = HashMapFactory.make();
    private final byte[] val;
    private final int hash;

    public static Atom findOrCreateUnicodeAtom(String string) {
        byte[] byArray = UTF8Convert.toUTF8(string);
        return Atom.findOrCreate(byArray);
    }

    public static Atom findOrCreateAsciiAtom(String string) {
        if (string == null) {
            throw new IllegalArgumentException("str is null");
        }
        byte[] byArray = string.getBytes();
        return Atom.findOrCreate(byArray);
    }

    public static Atom findOrCreateUtf8Atom(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("utf8 is null");
        }
        return Atom.findOrCreate(byArray);
    }

    public static Atom findOrCreate(byte[] byArray, int n, int n2) throws IllegalArgumentException, IllegalArgumentException, IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("utf8 == null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len must be >= 0, " + n2);
        }
        if (n < 0) {
            throw new IllegalArgumentException("off must be >= 0, " + n);
        }
        if (byArray.length < n + n2) {
            throw new IllegalArgumentException("utf8.length < off + len");
        }
        if (n + n2 < 0) {
            throw new IllegalArgumentException("off + len is too big: " + n + " + " + n2);
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray2[n3] = byArray[n++];
            ++n3;
        }
        return Atom.findOrCreate(byArray2);
    }

    public static synchronized Atom findOrCreate(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes is null");
        }
        AtomKey atomKey = new AtomKey(byArray);
        Atom atom = dictionary.get(atomKey);
        if (atom != null) {
            return atom;
        }
        atom = new Atom(atomKey);
        dictionary.put(atomKey, atom);
        return atom;
    }

    public static synchronized Atom findOrCreate(ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Atom.findOrCreate(immutableByteArray.b);
    }

    public static synchronized Atom findOrCreate(ImmutableByteArray immutableByteArray, int n, int n2) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Atom.findOrCreate(immutableByteArray.b, n, n2);
    }

    public final String toString() {
        return new String(this.val);
    }

    public final String toUnicodeString() throws UTFDataFormatException {
        return UTF8Convert.fromUTF8(this.val);
    }

    public final Atom arrayDescriptorFromElementDescriptor() {
        byte[] byArray = new byte[1 + this.val.length];
        byArray[0] = 91;
        int n = 0;
        int n2 = this.val.length;
        while (n < n2) {
            byArray[n + 1] = this.val[n];
            ++n;
        }
        return Atom.findOrCreate(byArray);
    }

    public final boolean isReservedMemberName() {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 60;
    }

    public final boolean isClassDescriptor() {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 76;
    }

    public final boolean isArrayDescriptor() {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 91;
    }

    public final boolean isMethodDescriptor() throws IllegalArgumentException {
        if (this.length() == 0) {
            return false;
        }
        return this.val[0] == 40;
    }

    public final int length() {
        return this.val.length;
    }

    private Atom(AtomKey atomKey) {
        this.val = atomKey.val;
        this.hash = atomKey.hash;
    }

    public final Atom parseForArrayElementDescriptor() throws IllegalArgumentException {
        if (this.val.length == 0) {
            throw new IllegalArgumentException("empty atom is not an array");
        }
        return Atom.findOrCreate(this.val, 1, this.val.length - 1);
    }

    public final int parseForArrayDimensionality() throws IllegalArgumentException {
        if (this.val.length == 0) {
            throw new IllegalArgumentException("empty atom is not an array");
        }
        try {
            int n = 0;
            while (true) {
                if (this.val[n] != 91) {
                    return n;
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException("not an array: " + this);
        }
    }

    public final Atom parseForInnermostArrayElementDescriptor() throws IllegalArgumentException {
        if (this.val.length == 0) {
            throw new IllegalArgumentException("empty atom is not an array");
        }
        try {
            int n = 0;
            while (this.val[n] == 91) {
                ++n;
            }
            return Atom.findOrCreate(this.val, n, this.val.length - n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalStateException("not an array: " + this);
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public byte[] getValArray() {
        byte[] byArray = new byte[this.val.length];
        System.arraycopy(this.val, 0, byArray, 0, this.val.length);
        return byArray;
    }

    public byte getVal(int n) throws IllegalArgumentException {
        try {
            return this.val[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Illegal index: " + n + " length is " + this.val.length);
        }
    }

    public boolean contains(byte by) {
        int n = 0;
        while (n < this.val.length) {
            if (this.val[n] == by) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static Atom concat(byte by, byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 1];
        byArray2[0] = by;
        System.arraycopy(byArray, 0, byArray2, 1, byArray.length);
        return Atom.findOrCreate(byArray2);
    }

    public static Atom concat(byte by, ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        return Atom.concat(by, immutableByteArray.b);
    }

    public static boolean isArrayDescriptor(ImmutableByteArray immutableByteArray) {
        if (immutableByteArray == null) {
            throw new IllegalArgumentException("b is null");
        }
        if (immutableByteArray.length() == 0) {
            return false;
        }
        return immutableByteArray.get(0) == 91;
    }

    private Object readResolve() {
        return Atom.findOrCreate(this.val);
    }

    private static final class AtomKey {
        private final byte[] val;
        private final int hash;

        private AtomKey(byte[] byArray) {
            int n = 99989;
            int n2 = byArray.length;
            while (--n2 >= 0) {
                n = 99991 * n + byArray[n2];
            }
            this.val = byArray;
            this.hash = n;
        }

        public final boolean equals(Object object) {
            assert (object != null && this.getClass().equals(object.getClass()));
            if (this == object) {
                return true;
            }
            AtomKey atomKey = (AtomKey)object;
            if (this.hash != atomKey.hash) {
                return false;
            }
            if (this.val.length != atomKey.val.length) {
                return false;
            }
            int n = 0;
            while (n < this.val.length) {
                if (this.val[n] != atomKey.val[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public final String toString() {
            return new String(this.val);
        }

        public final int hashCode() {
            return this.hash;
        }
    }
}

