/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.scope;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.impl.DefaultEntrypoint;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitEntryPoints {
    private static final boolean DEBUG = false;

    public static Iterable<Entrypoint> make(IClassHierarchy iClassHierarchy) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        final HashSet hashSet = HashSetFactory.make();
        for (IClass iClass : iClassHierarchy) {
            if (!iClass.getClassLoader().getReference().equals(ClassLoaderReference.Application) || !JUnitEntryPoints.isJUnitTestCase(iClass)) continue;
            System.out.println("application class: " + iClass);
            Collection<IMethod> collection = iClass.getAllMethods();
            for (IMethod iMethod : collection) {
                if (!JUnitEntryPoints.isJUnitMethod(iMethod)) continue;
                hashSet.add(new DefaultEntrypoint(iMethod, iClassHierarchy));
                System.out.println("- adding test method as entry point: " + iMethod.getName().toString());
            }
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return hashSet.iterator();
            }
        };
    }

    public static Iterable<Entrypoint> makeOne(IClassHierarchy iClassHierarchy, String string, String string2, String string3) {
        if (iClassHierarchy == null) {
            throw new IllegalArgumentException("cha is null");
        }
        Atom atom = Atom.findOrCreateAsciiAtom(string);
        Atom atom2 = Atom.findOrCreateAsciiAtom(string2);
        TypeName typeName = TypeName.findOrCreateClass(atom, atom2);
        Atom atom3 = Atom.findOrCreateAsciiAtom(string3);
        final HashSet hashSet = HashSetFactory.make();
        try {
            for (IClass iClass : iClassHierarchy) {
                Object object;
                TypeName typeName2 = iClass.getName();
                if (!typeName2.equals(typeName) || !JUnitEntryPoints.isJUnitTestCase(iClass)) continue;
                for (IMethod iMethod : iClass.getDeclaredMethods()) {
                    object = iMethod.getName();
                    if (!((Atom)object).equals(atom3)) continue;
                    hashSet.add(new DefaultEntrypoint(iMethod, iClassHierarchy));
                    System.out.println("- adding entry point of the call graph: " + ((Atom)object).toString());
                }
                Set<IMethod> set = JUnitEntryPoints.getSetUpTearDownMethods(iClass);
                object = set.iterator();
                while (object.hasNext()) {
                    IMethod iMethod;
                    iMethod = (IMethod)object.next();
                    hashSet.add(new DefaultEntrypoint(iMethod, iClassHierarchy));
                }
            }
        }
        catch (ClassHierarchyException classHierarchyException) {
            classHierarchyException.printStackTrace();
        }
        return new Iterable<Entrypoint>(){

            @Override
            public Iterator<Entrypoint> iterator() {
                return hashSet.iterator();
            }
        };
    }

    public static boolean isJUnitTestCase(IClass iClass) {
        if (iClass == null) {
            throw new IllegalArgumentException("klass is null");
        }
        Atom atom = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom atom2 = Atom.findOrCreateAsciiAtom("TestCase");
        Atom atom3 = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName typeName = TypeName.findOrCreateClass(atom, atom2);
        TypeName typeName2 = TypeName.findOrCreateClass(atom, atom3);
        IClass iClass2 = iClass.getSuperclass();
        while (iClass2 != null) {
            TypeName typeName3 = iClass2.getName();
            if (typeName3.equals(typeName) || typeName3.equals(typeName2)) {
                return true;
            }
            iClass2 = iClass2.getSuperclass();
        }
        return false;
    }

    public static boolean isJUnitMethod(IMethod iMethod) {
        if (iMethod == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (!JUnitEntryPoints.isJUnitTestCase(iMethod.getDeclaringClass())) {
            return false;
        }
        Atom atom = iMethod.getName();
        String string = atom.toString();
        return string.startsWith("test") || string.equals("setUp") || string.equals("tearDown");
    }

    public static Set<IMethod> getSetUpTearDownMethods(IClass iClass) throws ClassHierarchyException {
        Atom atom = Atom.findOrCreateAsciiAtom("junit/framework");
        Atom atom2 = Atom.findOrCreateAsciiAtom("TestCase");
        Atom atom3 = Atom.findOrCreateAsciiAtom("TestSuite");
        TypeName typeName = TypeName.findOrCreateClass(atom, atom2);
        TypeName typeName2 = TypeName.findOrCreateClass(atom, atom3);
        Atom atom4 = Atom.findOrCreateAsciiAtom("setUp");
        Atom atom5 = Atom.findOrCreateAsciiAtom("tearDown");
        HashSet<IMethod> hashSet = HashSetFactory.make();
        IClass iClass2 = iClass;
        while (iClass2 != null && !iClass2.getName().equals(typeName) && !iClass2.getName().equals(typeName2)) {
            for (IMethod iMethod : iClass2.getDeclaredMethods()) {
                Atom atom6 = iMethod.getName();
                if (!atom6.equals(atom4) && !atom6.equals(atom5) && !iMethod.isClinit() && !iMethod.isInit()) continue;
                hashSet.add(iMethod);
            }
            iClass2 = iClass2.getSuperclass();
        }
        return hashSet;
    }
}

