/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.perf;

import com.ibm.wala.util.perf.Stopwatch;

public class StopwatchGC
extends Stopwatch {
    private final String name;
    private long startMemory;
    private long endMemory;

    public StopwatchGC(String string) {
        this.name = string;
    }

    public final void start() {
        if (this.count == 0) {
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            this.startMemory = runtime.totalMemory() - runtime.freeMemory();
        }
        super.start();
    }

    public final void stop() {
        super.stop();
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        this.endMemory = runtime.totalMemory() - runtime.freeMemory();
    }

    public final String report() {
        String string = "";
        if (this.getCount() > 0) {
            string = String.valueOf(string) + "Stopwatch: " + this.name + " " + this.getElapsedMillis() + " ms" + "\n";
        }
        if (this.getCount() == 1) {
            string = String.valueOf(string) + "       Footprint at entry: " + (float)this.startMemory / 1000000.0f + " MB\n";
            string = String.valueOf(string) + "        Footprint at exit: " + (float)this.endMemory / 1000000.0f + " MB\n";
            string = String.valueOf(string) + "                    Delta: " + (float)(this.endMemory - this.startMemory) / 1000000.0f + " MB\n";
        }
        return string;
    }

    public float getEndMemory() {
        return (float)this.endMemory / 1000000.0f;
    }

    public float getStartMemory() {
        return (float)this.startMemory / 1000000.0f;
    }

    public float getFootprint() {
        return this.getEndMemory() - this.getStartMemory();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(", Delta: " + (float)(this.endMemory - this.startMemory) / 1000000.0f + " MB");
        return stringBuffer.toString();
    }
}

