/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.MutableSparseLongSet;

public class SparseLongIntVector {
    private static final int INITIAL_SIZE = 5;
    private final double EXPANSION = 1.5;
    private final MutableSparseLongSet indices = new MutableSparseLongSet();
    private int[] data = new int[5];
    private final int defaultValue;

    public SparseLongIntVector(int n) {
        this.defaultValue = n;
    }

    public int get(long l) {
        int n = this.indices.getIndex(l);
        if (n == -1) {
            return this.defaultValue;
        }
        return this.data[n];
    }

    public void set(long l, int n) {
        int n2 = this.indices.getIndex(l);
        if (n2 == -1) {
            this.indices.add(l);
            n2 = this.indices.getIndex(l);
            this.ensureCapacity(this.indices.size() + 1);
            if (n2 < this.data.length - 1) {
                System.arraycopy(this.data, n2, this.data, n2 + 1, this.indices.size() - n2);
            }
        }
        this.data[n2] = n;
    }

    private void ensureCapacity(int n) {
        if (this.data.length < n + 1) {
            int[] nArray = this.data;
            this.data = new int[1 + (int)((double)n * 1.5)];
            System.arraycopy(nArray, 0, this.data, 0, nArray.length);
        }
    }

    public void performVerboseAction() {
        System.err.println(this.getClass() + " stats: ");
        System.err.println("data.length " + this.data.length);
        System.err.println("indices.size() " + this.indices.size());
    }
}

