/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.intset.BimodalMutableIntSet;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetAction;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableSharedBitVectorIntSet;
import com.ibm.wala.util.intset.MutableSparseIntSet;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SparseIntSet
implements IntSet {
    private static final int SINGLETON_CACHE_SIZE = 5000;
    private static final SparseIntSet[] singletonCache = new SparseIntSet[5000];
    protected int[] elements;
    protected int size = 0;

    static {
        int n = 0;
        while (n < 5000) {
            SparseIntSet.singletonCache[n] = new SparseIntSet(new int[]{n});
            ++n;
        }
    }

    protected SparseIntSet(int n) {
        this.elements = new int[n];
        this.size = n;
    }

    protected SparseIntSet(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("backingArray is null");
        }
        this.elements = nArray;
        this.size = nArray.length;
    }

    public SparseIntSet() {
        this.elements = null;
        this.size = 0;
    }

    protected SparseIntSet(SparseIntSet sparseIntSet) {
        this.cloneState(sparseIntSet);
    }

    private void cloneState(SparseIntSet sparseIntSet) {
        this.elements = (int[])(sparseIntSet.elements != null ? (int[])sparseIntSet.elements.clone() : null);
        this.size = sparseIntSet.size;
    }

    public SparseIntSet(IntSet intSet) throws IllegalArgumentException {
        if (intSet == null) {
            throw new IllegalArgumentException("S == null");
        }
        if (intSet instanceof SparseIntSet) {
            this.cloneState((SparseIntSet)intSet);
        } else {
            this.elements = new int[intSet.size()];
            this.size = intSet.size();
            intSet.foreach(new IntSetAction(){
                private int index = 0;

                public void act(int n) {
                    SparseIntSet.this.elements[this.index++] = n;
                }
            });
        }
    }

    public final boolean contains(int n) {
        if (this.elements == null) {
            return false;
        }
        return IntSetUtil.binarySearch(this.elements, n, 0, this.size - 1) >= 0;
    }

    public final int getIndex(int n) {
        if (this.elements == null) {
            return -1;
        }
        return IntSetUtil.binarySearch(this.elements, n, 0, this.size - 1);
    }

    public final int size() {
        return this.size;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int elementAt(int n) throws NoSuchElementException {
        if (n < 0) {
            throw new IllegalArgumentException("invalid idx: " + n);
        }
        if (this.elements == null || n >= this.size) {
            throw new NoSuchElementException("Index: " + n);
        }
        return this.elements[n];
    }

    private boolean sameValueInternal(SparseIntSet sparseIntSet) {
        if (this.size != sparseIntSet.size) {
            return false;
        }
        int n = 0;
        while (n < this.size) {
            if (this.elements[n] != sparseIntSet.elements[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean sameValue(IntSet intSet) throws IllegalArgumentException, UnimplementedError {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof SparseIntSet) {
            return this.sameValueInternal((SparseIntSet)intSet);
        }
        if (intSet instanceof BimodalMutableIntSet) {
            return intSet.sameValue(this);
        }
        if (intSet instanceof BitVectorIntSet) {
            return intSet.sameValue(this);
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            return this.sameValue(((MutableSharedBitVectorIntSet)intSet).makeSparseCopy());
        }
        Assertions.UNREACHABLE(intSet.getClass().toString());
        return false;
    }

    private boolean isSubsetInternal(SparseIntSet sparseIntSet) {
        if (this.elements == null) {
            return true;
        }
        if (sparseIntSet.elements == null) {
            return false;
        }
        if (this.equals(sparseIntSet)) {
            return true;
        }
        if (this.sameValue(sparseIntSet)) {
            return true;
        }
        int[] nArray = this.elements;
        int n = 0;
        int n2 = this.size;
        int[] nArray2 = sparseIntSet.elements;
        int n3 = 0;
        int n4 = sparseIntSet.size;
        while (n < n2 && n3 < n4) {
            int n5 = nArray[n] - nArray2[n3];
            if (n5 > 0) {
                ++n3;
                continue;
            }
            if (n5 < 0) {
                return false;
            }
            ++n;
            ++n3;
        }
        return n3 != n4 || n >= n2;
    }

    public static SparseIntSet diff(SparseIntSet sparseIntSet, SparseIntSet sparseIntSet2) {
        return new SparseIntSet(SparseIntSet.diffInternal(sparseIntSet, sparseIntSet2));
    }

    public static int[] diffInternal(SparseIntSet sparseIntSet, SparseIntSet sparseIntSet2) {
        int n;
        if (sparseIntSet == null) {
            throw new IllegalArgumentException("A is null");
        }
        if (sparseIntSet2 == null) {
            throw new IllegalArgumentException("B is null");
        }
        if (sparseIntSet.isEmpty()) {
            return new int[0];
        }
        if (sparseIntSet2.isEmpty()) {
            int[] nArray = new int[sparseIntSet.size];
            System.arraycopy(sparseIntSet.elements, 0, nArray, 0, sparseIntSet.size);
            return nArray;
        }
        if (sparseIntSet.equals(sparseIntSet2)) {
            return new int[0];
        }
        if (sparseIntSet.sameValue(sparseIntSet2)) {
            return new int[0];
        }
        int[] nArray = sparseIntSet.elements;
        int n2 = 0;
        int n3 = sparseIntSet.size;
        int[] nArray2 = sparseIntSet2.elements;
        int n4 = 0;
        int n5 = sparseIntSet2.size;
        int[] nArray3 = new int[n3];
        int n6 = 0;
        while (n2 < n3 && n4 < n5) {
            n = nArray[n2] - nArray2[n4];
            if (n > 0) {
                ++n4;
                continue;
            }
            if (n < 0) {
                nArray3[n6++] = nArray[n2];
                ++n2;
                continue;
            }
            ++n2;
            ++n4;
        }
        if (n2 < n3) {
            n = n3 - n2;
            System.arraycopy(nArray, n2, nArray3, n6, n);
            n6 += n;
        }
        nArray = new int[n6];
        System.arraycopy(nArray3, 0, nArray, 0, n6);
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(6 * this.size);
        stringBuffer.append("{ ");
        if (this.elements != null) {
            int n = 0;
            while (n < this.size) {
                stringBuffer.append(this.elements[n]);
                stringBuffer.append(" ");
                ++n;
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public static int[] parseIntArray(String string) {
        if (string == null) {
            throw new IllegalArgumentException("str is null");
        }
        int n = string.length();
        if (n == 0 || string.charAt(0) != '{' || string.charAt(n - 1) != '}') {
            throw new IllegalArgumentException(string);
        }
        string = string.substring(1, n - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            treeSet.add(Integer.decode(stringTokenizer.nextToken()));
        }
        int[] nArray = new int[treeSet.size()];
        int n2 = 0;
        for (Integer n3 : treeSet) {
            nArray[n2++] = n3;
        }
        return nArray;
    }

    public static SparseIntSet singleton(int n) {
        if (n >= 0 && n < 5000) {
            return singletonCache[n];
        }
        return new SparseIntSet(new int[]{n});
    }

    public static SparseIntSet pair(int n, int n2) {
        if (n == n2) {
            return SparseIntSet.singleton(n);
        }
        if (n2 > n) {
            return new SparseIntSet(new int[]{n, n2});
        }
        return new SparseIntSet(new int[]{n2, n});
    }

    public IntSet intersection(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("that == null");
        }
        if (intSet instanceof SparseIntSet) {
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(this);
            mutableSparseIntSet.intersectWith((SparseIntSet)intSet);
            return mutableSparseIntSet;
        }
        if (intSet instanceof BitVectorIntSet) {
            SparseIntSet sparseIntSet = ((BitVectorIntSet)intSet).toSparseIntSet();
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(this);
            mutableSparseIntSet.intersectWith(sparseIntSet);
            return mutableSparseIntSet;
        }
        if (intSet instanceof MutableSharedBitVectorIntSet) {
            MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.make(this);
            mutableSparseIntSet.intersectWith(intSet);
            return mutableSparseIntSet;
        }
        MutableSparseIntSet mutableSparseIntSet = MutableSparseIntSet.makeEmpty();
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            int n = intIterator.next();
            if (!intSet.contains(n)) continue;
            mutableSparseIntSet.add(n);
        }
        return mutableSparseIntSet;
    }

    public IntSet union(IntSet intSet) {
        MutableSparseIntSet mutableSparseIntSet = new MutableSparseIntSet();
        mutableSparseIntSet.addAll(this);
        mutableSparseIntSet.addAll(intSet);
        return mutableSparseIntSet;
    }

    public IntIterator intIterator() {
        return new IntIterator(){
            int i = 0;

            public boolean hasNext() {
                return this.i < SparseIntSet.this.size;
            }

            public int next() throws NoSuchElementException {
                if (SparseIntSet.this.elements == null) {
                    throw new NoSuchElementException();
                }
                return SparseIntSet.this.elements[this.i++];
            }
        };
    }

    public final int max() throws IllegalStateException {
        if (this.elements == null) {
            throw new IllegalStateException("Illegal to ask max() on an empty int set");
        }
        return this.size > 0 ? this.elements[this.size - 1] : -1;
    }

    public void foreach(IntSetAction intSetAction) {
        if (intSetAction == null) {
            throw new IllegalArgumentException("null action");
        }
        int n = 0;
        while (n < this.size) {
            intSetAction.act(this.elements[n]);
            ++n;
        }
    }

    public void foreachExcluding(IntSet intSet, IntSetAction intSetAction) {
        if (intSetAction == null) {
            throw new IllegalArgumentException("null action");
        }
        int n = 0;
        while (n < this.size) {
            if (!intSet.contains(this.elements[n])) {
                intSetAction.act(this.elements[n]);
            }
            ++n;
        }
    }

    public static SparseIntSet add(SparseIntSet sparseIntSet, int n) {
        if (sparseIntSet == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (sparseIntSet.elements == null) {
            return SparseIntSet.singleton(n);
        }
        SparseIntSet sparseIntSet2 = new SparseIntSet(sparseIntSet.size + 1);
        int n2 = 0;
        int n3 = 0;
        while (n2 < sparseIntSet.elements.length && sparseIntSet.elements[n2] < n) {
            sparseIntSet2.elements[n2++] = sparseIntSet.elements[n3++];
        }
        if (n2 == sparseIntSet.size) {
            sparseIntSet2.elements[n2] = n;
        } else {
            if (sparseIntSet.elements[n2] == n) {
                --sparseIntSet2.size;
            } else {
                sparseIntSet2.elements[n2++] = n;
            }
            while (n2 < sparseIntSet2.size) {
                sparseIntSet2.elements[n2++] = sparseIntSet.elements[n3++];
            }
        }
        return sparseIntSet2;
    }

    public boolean isSubset(IntSet intSet) {
        if (intSet == null) {
            throw new IllegalArgumentException("null that");
        }
        if (intSet instanceof SparseIntSet) {
            return this.isSubsetInternal((SparseIntSet)intSet);
        }
        if (intSet instanceof BitVectorIntSet) {
            return this.isSubsetInternal((BitVectorIntSet)intSet);
        }
        IntIterator intIterator = this.intIterator();
        while (intIterator.hasNext()) {
            if (intSet.contains(intIterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isSubsetInternal(BitVectorIntSet bitVectorIntSet) {
        int n = 0;
        while (n < this.size) {
            if (!bitVectorIntSet.contains(this.elements[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean containsAny(IntSet intSet) {
        if (intSet instanceof SparseIntSet) {
            return this.containsAny((SparseIntSet)intSet);
        }
        if (intSet instanceof BimodalMutableIntSet) {
            return intSet.containsAny(this);
        }
        int n = 0;
        while (n < this.size) {
            if (intSet.contains(this.elements[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean containsAny(SparseIntSet sparseIntSet) throws IllegalArgumentException {
        if (sparseIntSet == null) {
            throw new IllegalArgumentException("set == null");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < sparseIntSet.size) {
            int n3 = sparseIntSet.elements[n2];
            while (n < this.size && this.elements[n] < n3) {
                ++n;
            }
            if (n == this.size) {
                return false;
            }
            if (this.elements[n] == n3) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int[] toIntArray() {
        int[] nArray = new int[this.size];
        if (this.size > 0) {
            System.arraycopy(this.elements, 0, nArray, 0, this.size);
        }
        return nArray;
    }
}

