/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.IntVector;
import java.util.Arrays;

public class SimpleIntVector
implements IntVector {
    private static final int MAX_SIZE = 0x1FFFFFFF;
    private static final float GROWTH_FACTOR = 1.5f;
    private static final int INITIAL_SIZE = 1;
    int maxIndex = -1;
    int[] store;
    final int defaultValue;

    public SimpleIntVector(int n) {
        this.defaultValue = n;
        this.store = new int[this.getInitialSize()];
        this.store[0] = n;
    }

    public SimpleIntVector(int n, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Illegal initialSize: " + n2);
        }
        this.defaultValue = n;
        this.store = new int[n2];
        this.store[0] = n;
    }

    int getInitialSize() {
        return 1;
    }

    float getGrowthFactor() {
        return 1.5f;
    }

    public int get(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        if (n < this.store.length) {
            return this.store[n];
        }
        return this.defaultValue;
    }

    public void set(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("illegal x: " + n);
        }
        if (n > 0x1FFFFFFF) {
            throw new IllegalArgumentException("x is too big: " + n);
        }
        this.maxIndex = Math.max(this.maxIndex, n);
        if (n2 == this.defaultValue) {
            if (n >= this.store.length) {
                return;
            }
            this.store[n] = n2;
        } else {
            this.ensureCapacity(n);
            this.store[n] = n2;
        }
    }

    private void ensureCapacity(int n) {
        if (n >= this.store.length) {
            int[] nArray = this.store;
            this.store = new int[1 + (int)(this.getGrowthFactor() * (float)n)];
            Arrays.fill(this.store, this.defaultValue);
            System.arraycopy(nArray, 0, this.store, 0, nArray.length);
        }
    }

    public void performVerboseAction() {
        System.err.println("size:       " + this.store.length);
        System.err.println("occupancy:  " + this.computeOccupancy());
    }

    private double computeOccupancy() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.store.length) {
            if (this.store[n2] != -1) {
                ++n;
            }
            ++n2;
        }
        n2 = n;
        return (double)n2 / (double)this.store.length;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }
}

